/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.servicebus;

import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.cyberway.mp.bc.event.AutoDeclareConfig;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import java.time.Duration;

public class ServiceBusQueueDeclareConfig
extends AutoDeclareConfig {
    private boolean updateIfExisted = false;
    private QueueConfig queueConfig = new QueueConfig();

    public ServiceBusQueueDeclareConfig(FrameworkEventListener frameworkEventListener) {
        super(frameworkEventListener);
    }

    public boolean isUpdateIfExisted() {
        return this.updateIfExisted;
    }

    public void setUpdateIfExisted(boolean updateIfExisted) {
        this.updateIfExisted = updateIfExisted;
    }

    public QueueConfig getQueueConfig() {
        return this.queueConfig;
    }

    public void setQueueConfig(QueueConfig queueConfig) {
        this.queueConfig = queueConfig;
    }

    public static class QueueConfig {
        private Duration autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        private Duration defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        private Duration duplicateDetectionHistoryTimeWindow = ServiceBusConstants.DEFAULT_DUPLICATE_DETECTION_DURATION;
        private boolean enableBatchedOperations = true;
        private boolean enablePartitioning = false;
        private Duration lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        private int maxDeliveryCount = 10;
        private int maxSizeInMegabytes = 1024;
        private boolean requiresDuplicateDetection = false;
        private boolean deadLetteringOnMessageExpiration = false;
        private boolean requiresSession = false;
        private EntityStatus status = EntityStatus.ACTIVE;

        public boolean isDeadLetteringOnMessageExpiration() {
            return this.deadLetteringOnMessageExpiration;
        }

        public void setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
            this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        }

        public Duration getAutoDeleteOnIdle() {
            return this.autoDeleteOnIdle;
        }

        public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
            this.autoDeleteOnIdle = autoDeleteOnIdle;
        }

        public Duration getDefaultMessageTimeToLive() {
            return this.defaultMessageTimeToLive;
        }

        public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
            this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        }

        public Duration getDuplicateDetectionHistoryTimeWindow() {
            return this.duplicateDetectionHistoryTimeWindow;
        }

        public void setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
            this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        }

        public boolean isEnableBatchedOperations() {
            return this.enableBatchedOperations;
        }

        public void setEnableBatchedOperations(boolean enableBatchedOperations) {
            this.enableBatchedOperations = enableBatchedOperations;
        }

        public boolean isEnablePartitioning() {
            return this.enablePartitioning;
        }

        public void setEnablePartitioning(boolean enablePartitioning) {
            this.enablePartitioning = enablePartitioning;
        }

        public Duration getLockDuration() {
            return this.lockDuration;
        }

        public void setLockDuration(Duration lockDuration) {
            this.lockDuration = lockDuration;
        }

        public int getMaxDeliveryCount() {
            return this.maxDeliveryCount;
        }

        public void setMaxDeliveryCount(int maxDeliveryCount) {
            this.maxDeliveryCount = maxDeliveryCount;
        }

        public int getMaxSizeInMegabytes() {
            return this.maxSizeInMegabytes;
        }

        public void setMaxSizeInMegabytes(int maxSizeInMegabytes) {
            this.maxSizeInMegabytes = maxSizeInMegabytes;
        }

        public boolean isRequiresDuplicateDetection() {
            return this.requiresDuplicateDetection;
        }

        public void setRequiresDuplicateDetection(boolean requiresDuplicateDetection) {
            this.requiresDuplicateDetection = requiresDuplicateDetection;
        }

        public boolean isRequiresSession() {
            return this.requiresSession;
        }

        public void setRequiresSession(boolean requiresSession) {
            this.requiresSession = requiresSession;
        }

        public EntityStatus getStatus() {
            return this.status;
        }

        public void setStatus(EntityStatus status) {
            this.status = status;
        }

        public void updateQueueProperties(QueueProperties queueProperties) {
            queueProperties.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            queueProperties.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            queueProperties.setDuplicateDetectionHistoryTimeWindow(this.getDuplicateDetectionHistoryTimeWindow());
            queueProperties.setBatchedOperationsEnabled(this.isEnableBatchedOperations());
            queueProperties.setLockDuration(this.getLockDuration());
            queueProperties.setMaxDeliveryCount(Integer.valueOf(this.getMaxDeliveryCount()));
            queueProperties.setMaxSizeInMegabytes(Integer.valueOf(this.getMaxSizeInMegabytes()));
            queueProperties.setStatus(this.getStatus());
            queueProperties.setDeadLetteringOnMessageExpiration(this.isDeadLetteringOnMessageExpiration());
        }

        public CreateQueueOptions toCreateQueueOptions() {
            CreateQueueOptions createQueueOptions = new CreateQueueOptions();
            createQueueOptions.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            createQueueOptions.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            createQueueOptions.setDuplicateDetectionHistoryTimeWindow(this.getDuplicateDetectionHistoryTimeWindow());
            createQueueOptions.setBatchedOperationsEnabled(this.isEnableBatchedOperations());
            createQueueOptions.setPartitioningEnabled(this.isEnablePartitioning());
            createQueueOptions.setLockDuration(this.getLockDuration());
            createQueueOptions.setMaxDeliveryCount(this.getMaxDeliveryCount());
            createQueueOptions.setMaxSizeInMegabytes(this.getMaxSizeInMegabytes());
            createQueueOptions.setDuplicateDetectionRequired(this.isRequiresDuplicateDetection());
            createQueueOptions.setSessionRequired(this.isRequiresSession());
            createQueueOptions.setStatus(this.getStatus());
            return createQueueOptions;
        }
    }
}

