/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.servicebus;

import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.cyberway.mp.bc.event.AutoDeclareConfig;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import java.time.Duration;

public class ServiceBusTopicSubscriptionDeclareConfig
extends AutoDeclareConfig {
    private boolean updateIfExisted = false;
    private TopicConfig topicConfig = new TopicConfig();
    private SubscriptionConfig subscriptionConfig = new SubscriptionConfig();

    public ServiceBusTopicSubscriptionDeclareConfig(FrameworkEventListener frameworkEventListener) {
        super(frameworkEventListener);
    }

    public boolean isUpdateIfExisted() {
        return this.updateIfExisted;
    }

    public void setUpdateIfExisted(boolean updateIfExisted) {
        this.updateIfExisted = updateIfExisted;
    }

    public TopicConfig getTopicConfig() {
        return this.topicConfig;
    }

    public void setTopicConfig(TopicConfig topicConfig) {
        this.topicConfig = topicConfig;
    }

    public SubscriptionConfig getSubscriptionConfig() {
        return this.subscriptionConfig;
    }

    public void setSubscriptionConfig(SubscriptionConfig subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
    }

    public static class TopicConfig {
        private Duration autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        private Duration defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        private Duration duplicateDetectionHistoryTimeWindow = ServiceBusConstants.DEFAULT_DUPLICATE_DETECTION_DURATION;
        private boolean enableBatchedOperations = true;
        private boolean enablePartitioning = false;
        private Duration lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        private int maxDeliveryCount = 10;
        private long maxSizeInMegabytes = 1024L;
        private boolean requiresDuplicateDetection = false;
        private boolean requiresSession = false;
        private EntityStatus status = EntityStatus.ACTIVE;

        public Duration getAutoDeleteOnIdle() {
            return this.autoDeleteOnIdle;
        }

        public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
            this.autoDeleteOnIdle = autoDeleteOnIdle;
        }

        public Duration getDefaultMessageTimeToLive() {
            return this.defaultMessageTimeToLive;
        }

        public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
            this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        }

        public Duration getDuplicateDetectionHistoryTimeWindow() {
            return this.duplicateDetectionHistoryTimeWindow;
        }

        public void setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
            this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        }

        public boolean isEnableBatchedOperations() {
            return this.enableBatchedOperations;
        }

        public void setEnableBatchedOperations(boolean enableBatchedOperations) {
            this.enableBatchedOperations = enableBatchedOperations;
        }

        public boolean isEnablePartitioning() {
            return this.enablePartitioning;
        }

        public void setEnablePartitioning(boolean enablePartitioning) {
            this.enablePartitioning = enablePartitioning;
        }

        public Duration getLockDuration() {
            return this.lockDuration;
        }

        public void setLockDuration(Duration lockDuration) {
            this.lockDuration = lockDuration;
        }

        public int getMaxDeliveryCount() {
            return this.maxDeliveryCount;
        }

        public void setMaxDeliveryCount(int maxDeliveryCount) {
            this.maxDeliveryCount = maxDeliveryCount;
        }

        public long getMaxSizeInMegabytes() {
            return this.maxSizeInMegabytes;
        }

        public void setMaxSizeInMegabytes(long maxSizeInMegabytes) {
            this.maxSizeInMegabytes = maxSizeInMegabytes;
        }

        public boolean isRequiresDuplicateDetection() {
            return this.requiresDuplicateDetection;
        }

        public void setRequiresDuplicateDetection(boolean requiresDuplicateDetection) {
            this.requiresDuplicateDetection = requiresDuplicateDetection;
        }

        public boolean isRequiresSession() {
            return this.requiresSession;
        }

        public void setRequiresSession(boolean requiresSession) {
            this.requiresSession = requiresSession;
        }

        public EntityStatus getStatus() {
            return this.status;
        }

        public void setStatus(EntityStatus status) {
            this.status = status;
        }

        public void updateTopicProperties(TopicProperties topicProperties) {
            topicProperties.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            topicProperties.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            topicProperties.setDuplicateDetectionHistoryTimeWindow(this.getDuplicateDetectionHistoryTimeWindow());
            topicProperties.setMaxSizeInMegabytes(this.getMaxSizeInMegabytes());
            topicProperties.setStatus(this.getStatus());
        }

        public CreateTopicOptions toCreateTopicOptions() {
            CreateTopicOptions createTopicOptions = new CreateTopicOptions();
            createTopicOptions.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            createTopicOptions.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            createTopicOptions.setDuplicateDetectionHistoryTimeWindow(this.getDuplicateDetectionHistoryTimeWindow());
            createTopicOptions.setBatchedOperationsEnabled(this.isEnableBatchedOperations());
            createTopicOptions.setPartitioningEnabled(this.isEnablePartitioning());
            createTopicOptions.setLockDuration(this.getLockDuration());
            createTopicOptions.setMaxDeliveryCount(this.getMaxDeliveryCount());
            createTopicOptions.setMaxSizeInMegabytes(this.getMaxSizeInMegabytes());
            createTopicOptions.setDuplicateDetectionRequired(this.isRequiresDuplicateDetection());
            createTopicOptions.setSessionRequired(this.isRequiresSession());
            createTopicOptions.setStatus(this.getStatus());
            return createTopicOptions;
        }
    }

    public static class SubscriptionConfig {
        private Duration autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        private Duration defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        private boolean deadLetteringOnMessageExpiration = false;
        private boolean deadLetteringOnFilterEvaluationExceptions = true;
        private boolean enableBatchedOperations = true;
        private EntityStatus status = EntityStatus.ACTIVE;
        private Duration lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        private int maxDeliveryCount = 10;
        private boolean requiresSession = false;

        public Duration getAutoDeleteOnIdle() {
            return this.autoDeleteOnIdle;
        }

        public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
            this.autoDeleteOnIdle = autoDeleteOnIdle;
        }

        public Duration getDefaultMessageTimeToLive() {
            return this.defaultMessageTimeToLive;
        }

        public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
            this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        }

        public boolean isDeadLetteringOnMessageExpiration() {
            return this.deadLetteringOnMessageExpiration;
        }

        public void setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
            this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        }

        public boolean isDeadLetteringOnFilterEvaluationExceptions() {
            return this.deadLetteringOnFilterEvaluationExceptions;
        }

        public void setDeadLetteringOnFilterEvaluationExceptions(boolean deadLetteringOnFilterEvaluationExceptions) {
            this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        }

        public boolean isEnableBatchedOperations() {
            return this.enableBatchedOperations;
        }

        public void setEnableBatchedOperations(boolean enableBatchedOperations) {
            this.enableBatchedOperations = enableBatchedOperations;
        }

        public EntityStatus getStatus() {
            return this.status;
        }

        public void setStatus(EntityStatus status) {
            this.status = status;
        }

        public Duration getLockDuration() {
            return this.lockDuration;
        }

        public void setLockDuration(Duration lockDuration) {
            this.lockDuration = lockDuration;
        }

        public int getMaxDeliveryCount() {
            return this.maxDeliveryCount;
        }

        public void setMaxDeliveryCount(int maxDeliveryCount) {
            this.maxDeliveryCount = maxDeliveryCount;
        }

        public boolean isRequiresSession() {
            return this.requiresSession;
        }

        public void setRequiresSession(boolean requiresSession) {
            this.requiresSession = requiresSession;
        }

        public void updateSubscriptionProperties(SubscriptionProperties subscriptionProperties) {
            subscriptionProperties.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            subscriptionProperties.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            subscriptionProperties.setDeadLetteringOnMessageExpiration(this.isDeadLetteringOnMessageExpiration());
            subscriptionProperties.setMaxDeliveryCount(this.getMaxDeliveryCount());
            subscriptionProperties.setLockDuration(this.getLockDuration());
            subscriptionProperties.setStatus(this.getStatus());
        }

        public CreateSubscriptionOptions toCreateSubscriptionOptions() {
            CreateSubscriptionOptions createSubscriptionOptions = new CreateSubscriptionOptions();
            createSubscriptionOptions.setAutoDeleteOnIdle(this.getAutoDeleteOnIdle());
            createSubscriptionOptions.setDefaultMessageTimeToLive(this.getDefaultMessageTimeToLive());
            createSubscriptionOptions.setDeadLetteringOnMessageExpiration(this.isDeadLetteringOnMessageExpiration());
            createSubscriptionOptions.setEnableDeadLetteringOnFilterEvaluationExceptions(this.isDeadLetteringOnFilterEvaluationExceptions());
            createSubscriptionOptions.setBatchedOperationsEnabled(this.isEnableBatchedOperations());
            createSubscriptionOptions.setLockDuration(this.getLockDuration());
            createSubscriptionOptions.setMaxDeliveryCount(this.getMaxDeliveryCount());
            createSubscriptionOptions.setSessionRequired(this.isRequiresSession());
            return createSubscriptionOptions;
        }
    }
}

