/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.config;

import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.service.kafka.KafkaConsumerInterceptor;
import com.cyberway.mp.bc.event.service.kafka.KafkaFrameworkEventServiceImpl;
import com.cyberway.mp.bc.event.service.kafka.KafkaProducerInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.support.converter.StringJsonMessageConverter;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"kafka"})
public class KafkaEventConfig
implements InitializingBean {
    public static final String EVENT_SERVICE_NAME = "kafkaEventService";
    private static final String INTERCEPTOR_CLASSES = "interceptor.classes";
    @Autowired
    private KafkaProperties kafkaProperties;

    @Bean(value={"kafkaEventService"})
    public FrameworkEventService kafkaFrameworkEventService(FrameworkEventConfigProperties frameworkEventConfigProperties, KafkaTemplate<Object, Object> template) {
        ProducerFactory producerFactory = template.getProducerFactory();
        if (producerFactory instanceof DefaultKafkaProducerFactory) {
            Map configMap = producerFactory.getConfigurationProperties();
            ArrayList obj = configMap.getOrDefault(INTERCEPTOR_CLASSES, new ArrayList());
            HashMap interceptorMap = new HashMap();
            if (obj instanceof List) {
                List interceptorList = obj;
                interceptorList.add(KafkaProducerInterceptor.class.getName());
                interceptorMap.put(INTERCEPTOR_CLASSES, interceptorList);
            } else {
                interceptorMap.put(INTERCEPTOR_CLASSES, List.of(KafkaProducerInterceptor.class.getName(), obj));
            }
            producerFactory.updateConfigs(interceptorMap);
        }
        return new KafkaFrameworkEventServiceImpl(frameworkEventConfigProperties, template);
    }

    public void afterPropertiesSet() {
        this.kafkaProperties.getProducer().setValueSerializer(JsonSerializer.class);
    }

    @Bean
    public RecordMessageConverter converter() {
        return new StringJsonMessageConverter();
    }

    @Bean
    public RecordInterceptor kafkaConsumerInterceptor() {
        return new KafkaConsumerInterceptor();
    }
}

