/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.config;

import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.event.service.rocketmq.EventRocketMQListenerContainer;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQMessageListenerConcurrently;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQMessageListenerOrderly;
import com.cyberway.mp.bc.event.service.rocketmq.ServiceContextConsumeMessageHook;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"rocketmq"})
public class RocketmqBeanPostProcessor
implements BeanPostProcessor {
    private final ServiceContextConsumeMessageHook serviceContextConsumeMessageHook;

    public RocketmqBeanPostProcessor(ServiceContextConsumeMessageHook serviceContextConsumeMessageHook) {
        this.serviceContextConsumeMessageHook = serviceContextConsumeMessageHook;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DefaultRocketMQListenerContainer) {
            DefaultRocketMQListenerContainer container = (DefaultRocketMQListenerContainer)bean;
            DefaultMQPushConsumer consumer = container.getConsumer();
            consumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook((ConsumeMessageHook)this.serviceContextConsumeMessageHook);
            this.handleConsumer((RocketMQListenerContainer)container, consumer, container.getConsumeMode());
        } else if (bean instanceof EventRocketMQListenerContainer) {
            EventRocketMQListenerContainer container = (EventRocketMQListenerContainer)bean;
            DefaultMQPushConsumer consumer = container.getConsumer();
            consumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook((ConsumeMessageHook)this.serviceContextConsumeMessageHook);
            this.handleConsumer(container, consumer, container.getConsumeMode());
        }
        return bean;
    }

    private void handleConsumer(RocketMQListenerContainer container, DefaultMQPushConsumer consumer, ConsumeMode consumeMode) {
        switch (consumeMode) {
            case ORDERLY: {
                consumer.setMessageListener((MessageListener)new RocketMQMessageListenerOrderly(container));
                break;
            }
            case CONCURRENTLY: {
                consumer.setMessageListener((MessageListener)new RocketMQMessageListenerConcurrently(container));
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'consumeMode' was wrong.");
            }
        }
    }
}

