/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.config;

import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.ListenerLifecycle;
import com.cyberway.mp.bc.event.TransactionEventService;
import com.cyberway.mp.bc.event.anotation.rocketmq.RocketListenerContainerConfiguration;
import com.cyberway.mp.bc.event.config.RocketmqBeanPostProcessor;
import com.cyberway.mp.bc.event.service.rocketmq.RocketListenerLifecycle;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQFrameworkEventServiceImpl;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQTransactionEventServiceImpl;
import com.cyberway.mp.bc.event.service.rocketmq.ServiceContextConsumeMessageHook;
import com.cyberway.mp.bc.event.service.rocketmq.ServiceContextSendMessageHook;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"rocketmq"})
@Import(value={RocketListenerContainerConfiguration.class, RocketmqBeanPostProcessor.class})
public class RocketmqEventConfig {
    public static final String PRODUCER_BEAN_NAME = "defaultMQProducer";
    public static final String EVENT_SERVICE_NAME = "rocketEventService";
    public static final String TRANS_SERVICE_NAME = "rocketTransactionService";
    public static final String TRANS_PRODUCER_BEAN_NAME = "transMQProducer";
    public static final String TRANS_TEMPLATE_BEAN_NAME = "transTemplate";
    public static final String LIFE_CYCLE_NAME = "rocketLifecycle";

    @Bean(value={"rocketEventService"})
    public FrameworkEventService rocketmqFrameworkEventService(FrameworkEventConfigProperties frameworkEventConfigProperties, @Qualifier(value="rocketMQTemplate") RocketMQTemplate template, ServiceContextSendMessageHook sendMessageHook) {
        DefaultMQProducer producer = template.getProducer();
        DefaultMQProducerImpl impl = producer.getDefaultMQProducerImpl();
        impl.registerSendMessageHook((SendMessageHook)sendMessageHook);
        return new RocketMQFrameworkEventServiceImpl(frameworkEventConfigProperties, template);
    }

    @Bean(value={"rocketTransactionService"})
    public TransactionEventService rocketmqTransactionEventService(FrameworkEventConfigProperties frameworkEventConfigProperties, @Qualifier(value="transTemplate") RocketMQTemplate template) {
        return new RocketMQTransactionEventServiceImpl(frameworkEventConfigProperties, template);
    }

    @Bean(value={"rocketLifecycle"})
    public ListenerLifecycle rocketListenerLifecycle() {
        return new RocketListenerLifecycle();
    }

    @Bean
    public DefaultLitePullConsumer notUseConsumer() {
        return new DefaultLitePullConsumer();
    }

    @Bean(value={"defaultMQProducer"})
    public DefaultMQProducer defaultMQProducer(RocketMQProperties rocketMQProperties) {
        return this.createDefaultMQProducer(rocketMQProperties, PRODUCER_BEAN_NAME);
    }

    private DefaultMQProducer createDefaultMQProducer(RocketMQProperties rocketMQProperties, String defaultGroupName) {
        RocketMQProperties.Producer producerConfig = rocketMQProperties.getProducer();
        if (producerConfig == null) {
            producerConfig = new RocketMQProperties.Producer();
        }
        String nameServer = rocketMQProperties.getNameServer();
        String groupName = producerConfig.getGroup();
        if (!StringUtils.hasLength((String)groupName)) {
            groupName = defaultGroupName;
        }
        Assert.hasText((String)nameServer, (String)"[rocketmq.name-server] must not be null");
        String accessChannel = rocketMQProperties.getAccessChannel();
        String ak = producerConfig.getAccessKey();
        String sk = producerConfig.getSecretKey();
        boolean isEnableMsgTrace = producerConfig.isEnableMsgTrace();
        String customizedTraceTopic = producerConfig.getCustomizedTraceTopic();
        DefaultMQProducer producer = RocketMQUtil.createDefaultMQProducer((String)groupName, (String)ak, (String)sk, (boolean)isEnableMsgTrace, (String)customizedTraceTopic);
        producer.setNamesrvAddr(nameServer);
        if (StringUtils.hasLength((String)accessChannel)) {
            producer.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        producer.setSendMsgTimeout(producerConfig.getSendMessageTimeout());
        producer.setRetryTimesWhenSendFailed(producerConfig.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerConfig.getRetryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(producerConfig.getMaxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(producerConfig.getCompressMessageBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerConfig.isRetryNextServer());
        return producer;
    }

    @Bean(value={"transMQProducer"})
    public DefaultMQProducer defaultTransMQProducer(RocketMQProperties rocketMQProperties) {
        return this.createDefaultMQProducer(rocketMQProperties, TRANS_PRODUCER_BEAN_NAME);
    }

    @Bean(name={"transTemplate"}, destroyMethod="destroy")
    public RocketMQTemplate rocketMQTemplate(RocketMQMessageConverter rocketMQMessageConverter, @Qualifier(value="transMQProducer") DefaultMQProducer defaultMQProducer, RocketMQTemplate rocketMQTemplate, ServiceContextSendMessageHook sendMessageHook) {
        RocketMQTemplate eventRocketMQTemplate = new RocketMQTemplate();
        eventRocketMQTemplate.setProducer(defaultMQProducer);
        eventRocketMQTemplate.setMessageConverter(rocketMQMessageConverter.getMessageConverter());
        eventRocketMQTemplate.getProducer().getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)sendMessageHook);
        rocketMQTemplate.getProducer().getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)sendMessageHook);
        return eventRocketMQTemplate;
    }

    @Bean
    public ServiceContextSendMessageHook serviceContextSendMessageHook(ContextProperties contextProperties) {
        return new ServiceContextSendMessageHook(contextProperties);
    }

    @Bean
    public ServiceContextConsumeMessageHook serviceContextConsumeMessageHook(ContextProperties contextProperties) {
        return new ServiceContextConsumeMessageHook(contextProperties);
    }
}

