/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.config;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import com.azure.spring.cloud.autoconfigure.jms.implementation.AzureServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.cloud.autoconfigure.jms.properties.AzureServiceBusJmsProperties;
import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.anotation.servicebus.ServiceBusListenerAnnotationBeanPostProcessor;
import com.cyberway.mp.bc.event.service.servicebus.ServiceBusFrameworkEventServiceImpl;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import jakarta.jms.ConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"SERVICE_BUS"})
public class ServiceBusEventConfig {
    public static final String JMS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "jmsListenerContainerFactory";
    public static final String TOPIC_JMS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "topicJmsListenerContainerFactory";

    private static ServiceBusJmsConnectionFactory createJmsConnectionFactory(AzureServiceBusJmsProperties properties, FrameworkEventConfigProperties frameworkEventConfigProperties, ObjectProvider<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings(new HashMap());
        Map configurationOptions = settings.getConfigurationOptions();
        if (null != frameworkEventConfigProperties.getServiceBus() && StringUtils.hasLength((String)frameworkEventConfigProperties.getServiceBus().getProviderFutureType())) {
            configurationOptions.put("provider.futureType", frameworkEventConfigProperties.getServiceBus().getProviderFutureType());
        }
        AzureServiceBusJmsProperties.PrefetchPolicy prefetchProperties = properties.getPrefetchPolicy();
        configurationOptions.put("jms.prefetchPolicy.durableTopicPrefetch", String.valueOf(prefetchProperties.getDurableTopicPrefetch()));
        configurationOptions.put("jms.prefetchPolicy.queueBrowserPrefetch", String.valueOf(prefetchProperties.getQueueBrowserPrefetch()));
        configurationOptions.put("jms.prefetchPolicy.queuePrefetch", String.valueOf(prefetchProperties.getQueuePrefetch()));
        configurationOptions.put("jms.prefetchPolicy.topicPrefetch", String.valueOf(prefetchProperties.getTopicPrefetch()));
        try {
            ServiceBusJmsConnectionFactory factory;
            if (properties.isPasswordlessEnabled()) {
                String hostName = properties.getNamespace() + "." + properties.getProfile().getEnvironment().getServiceBusDomainName();
                TokenCredentialProvider tokenCredentialProvider = TokenCredentialProvider.createDefault((TokenCredentialProviderOptions)new TokenCredentialProviderOptions(properties.toPasswordlessProperties()));
                TokenCredential tokenCredential = (TokenCredential)tokenCredentialProvider.get();
                factory = (ServiceBusJmsConnectionFactory)ServiceBusJmsConnectionFactory.class.getConstructor(TokenCredential.class, String.class, ServiceBusJmsConnectionFactorySettings.class).newInstance(tokenCredential, hostName, settings);
            } else {
                factory = (ServiceBusJmsConnectionFactory)ServiceBusJmsConnectionFactory.class.getConstructor(String.class, ServiceBusJmsConnectionFactorySettings.class).newInstance(properties.getConnectionString(), settings);
            }
            if (StringUtils.hasText((String)properties.getTopicClientId())) {
                factory.setClientId(properties.getTopicClientId());
            }
            factoryCustomizers.orderedStream().forEach(customizer -> customizer.customize(factory));
            return factory;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to create JmsConnectionFactory", ex);
        }
    }

    @Bean
    @Primary
    public FrameworkEventService serviceBusFrameworkEventService(FrameworkEventConfigProperties frameworkEventConfigProperties, JmsTemplate template, @Qualifier(value="jacksonJmsMessageConverter") MessageConverter messageConverter) {
        template.setMessageConverter(messageConverter);
        return new ServiceBusFrameworkEventServiceImpl(frameworkEventConfigProperties, template);
    }

    @Bean
    public ServiceBusListenerAnnotationBeanPostProcessor serviceBusListenerAnnotationBeanPostProcessor(FrameworkEventConfigProperties frameworkEventConfigProperties, AzureServiceBusJmsProperties azureServiceBusJmsProperties) {
        return new ServiceBusListenerAnnotationBeanPostProcessor(frameworkEventConfigProperties, azureServiceBusJmsProperties);
    }

    @Bean
    public MessageConverter jacksonJmsMessageConverter() {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        converter.setObjectMapper(objectMapper);
        return converter;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="spring.jms.servicebus.pool", name={"enabled"}, havingValue="true")
        JmsPoolConnectionFactory jmsPoolConnectionFactory(AzureServiceBusJmsProperties properties, FrameworkEventConfigProperties frameworkEventConfigProperties, ObjectProvider<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
            ServiceBusJmsConnectionFactory factory = ServiceBusEventConfig.createJmsConnectionFactory(properties, frameworkEventConfigProperties, factoryCustomizers);
            return new JmsPoolConnectionFactoryFactory(properties.getPool()).createPooledConnectionFactory((ConnectionFactory)factory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.jms.servicebus.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class SimpleConnectionFactoryConfiguration {
        SimpleConnectionFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false")
        ServiceBusJmsConnectionFactory jmsConnectionFactory(AzureServiceBusJmsProperties properties, FrameworkEventConfigProperties frameworkEventConfigProperties, ObjectProvider<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
            return ServiceBusEventConfig.createJmsConnectionFactory(properties, frameworkEventConfigProperties, factoryCustomizers);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={CachingConnectionFactory.class})
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class CachingConnectionFactoryConfiguration {
            CachingConnectionFactoryConfiguration() {
            }

            @Bean
            CachingConnectionFactory jmsConnectionFactory(JmsProperties jmsProperties, AzureServiceBusJmsProperties properties, FrameworkEventConfigProperties frameworkEventConfigProperties, ObjectProvider<AzureServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
                ServiceBusJmsConnectionFactory factory = ServiceBusEventConfig.createJmsConnectionFactory(properties, frameworkEventConfigProperties, factoryCustomizers);
                CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)factory);
                JmsProperties.Cache cacheProperties = jmsProperties.getCache();
                connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
                connectionFactory.setCacheProducers(cacheProperties.isProducers());
                connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
                return connectionFactory;
            }
        }
    }
}

