/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.config;

import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.SpringEventConfigProperties;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.anotation.spring.SpringFrameworkEventListener;
import com.cyberway.mp.bc.event.client.SpringEventFeignClient;
import com.cyberway.mp.bc.event.service.spring.SpringEventConsumerService;
import com.cyberway.mp.bc.event.service.spring.SpringEventProduderService;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"spring"})
@EnableFeignClients(basePackages={"com.cyberway.mp.bc.event.client"})
@ComponentScan(value={"com.cyberway.mp.bc.event.controller"})
@Import(value={SpringEventConfigProperties.class})
public class SpringEventConfig
implements ApplicationContextAware,
SmartInitializingSingleton {
    private ApplicationContext applicationContext;
    public static Map<String, Object> frameworkEventBeanMap = null;

    @Bean
    public FrameworkEventService springFrameworkEventService(SpringEventConfigProperties springEventConfigProperties, SpringEventFeignClient springEventFeignClient, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        return new SpringEventProduderService(springEventConfigProperties, springEventFeignClient, frameworkEventConfigProperties);
    }

    @Bean
    public SpringEventConsumerService springEventConsumerService() {
        return new SpringEventConsumerService();
    }

    @Bean
    public ApplicationListener springFrameworkEventListener(SpringEventConsumerService springEventConsumerService) {
        return new SpringFrameworkEventListener(springEventConsumerService);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        frameworkEventBeanMap = this.applicationContext.getBeansWithAnnotation(FrameworkEventListener.class);
    }
}

