/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.bc.event.SpringFrameworkEvent;
import com.cyberway.mp.bc.event.service.spring.SpringEventConsumerService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/springEvent"})
@Tag(name="springEvent")
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"spring"})
public class SpringFrameworkEventController {
    private final SpringEventConsumerService springEventConsumerService;
    private final ParserConfig parserConfig;

    public SpringFrameworkEventController(SpringEventConsumerService springEventConsumerService) {
        this.springEventConsumerService = springEventConsumerService;
        this.parserConfig = new ParserConfig();
        this.parserConfig.setAutoTypeSupport(true);
    }

    @PostMapping(value={"consumer"})
    public ResponseResult<Void> consumer(@RequestBody SpringFrameworkEvent springFrameworkEvent) {
        Object object = null;
        try {
            String data = springFrameworkEvent.getData();
            object = data.contains("\"@type\"") ? JSON.parse((String)data, (ParserConfig)this.parserConfig) : JSON.parseObject((String)data, Class.forName(springFrameworkEvent.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new BaseException((Throwable)e);
        }
        this.springEventConsumerService.consumer(object);
        return ResponseResult.successResult();
    }
}

