/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.kafka;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.event.service.kafka.KafkaInterceptorConst;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.springframework.kafka.listener.RecordInterceptor;

public class KafkaConsumerInterceptor
implements RecordInterceptor<Object, Object> {
    public ConsumerRecord<Object, Object> intercept(ConsumerRecord<Object, Object> record, Consumer<Object, Object> consumer) {
        ServiceContext.removeContext();
        ServiceContext sc = ServiceContext.getContext();
        Headers headers = record.headers();
        for (Header header : headers) {
            if (KafkaInterceptorConst.getIgnoreHeaderSet().contains(header.key())) continue;
            sc.set(header.key(), (Object)new String(header.value()));
        }
        return record;
    }

    public void afterRecord(ConsumerRecord<Object, Object> record, Consumer<Object, Object> consumer) {
        ServiceContext.removeContext();
    }
}

