/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.kafka;

import com.cyberway.mp.bc.event.BaseFrameworkEventService;
import com.cyberway.mp.bc.event.ConfirmListener;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.service.kafka.KafkaTopicNameStrategy;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.core.KafkaTemplate;

@ConditionalOnProperty(name={"framework.event.type"}, havingValue="kafka")
@ConditionalOnMissingBean(value={FrameworkEventService.class})
@ConditionalOnBean(value={KafkaTemplate.class})
public class KafkaFrameworkEventServiceImpl
extends BaseFrameworkEventService
implements FrameworkEventService {
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final KafkaTemplate<Object, Object> template;

    public KafkaFrameworkEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, KafkaTemplate<Object, Object> template) {
        super(frameworkEventConfigProperties);
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.template = template;
    }

    @Override
    public void pushEvent(FrameworkEvent event) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        event.setSendTime(new Date());
        if (StringUtils.isBlank((CharSequence)this.frameworkEventConfigProperties.getKafka().getEventTopic())) {
            this.template.send(KafkaTopicNameStrategy.buildTopic(event.getClass(), this.frameworkEventConfigProperties), (Object)event);
        } else {
            this.template.send(this.frameworkEventConfigProperties.getKafka().getEventTopic(), (Object)this.buildKey(event), (Object)event);
        }
    }

    @Override
    public void pushEvent(FrameworkEvent event, String route) {
        throw new UnsupportedOperationException("kafka \u5b9e\u73b0\u4e0d\u652f\u6301 pushEvent \u65b9\u6cd5");
    }

    @Override
    public void pushEvent(FrameworkEvent event, String route, ConfirmListener callback) {
        throw new UnsupportedOperationException("kafka \u5b9e\u73b0\u4e0d\u652f\u6301 pushEvent \u65b9\u6cd5");
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        throw new UnsupportedOperationException("kafka \u5b9e\u73b0\u4e0d\u652f\u6301 syncPushEvent \u65b9\u6cd5");
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route) {
        throw new UnsupportedOperationException("kafka \u5b9e\u73b0\u4e0d\u652f\u6301 syncPushEvent \u65b9\u6cd5");
    }

    public String buildKey(FrameworkEvent event) {
        return StringUtils.defaultString((String)this.frameworkEventConfigProperties.getKafka().getKeyPrefix()) + event.getClass().getSimpleName() + StringUtils.defaultString((String)this.frameworkEventConfigProperties.getKafka().getKeySuffix());
    }
}

