/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.kafka;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.event.service.kafka.KafkaInterceptorConst;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaProducerInterceptor
implements ProducerInterceptor<Object, Object> {
    public ProducerRecord<Object, Object> onSend(ProducerRecord<Object, Object> record) {
        Headers headers = record.headers();
        ServiceContext sc = ServiceContext.getContext();
        Map context = sc.getKeys();
        for (final Map.Entry entry : context.entrySet()) {
            if (KafkaInterceptorConst.getIgnoreHeaderSet().contains(entry.getKey())) continue;
            headers.add(new Header(){

                public String key() {
                    return (String)entry.getKey();
                }

                public byte[] value() {
                    return entry.getValue().toString().getBytes();
                }
            });
        }
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

