/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rabbitmq;

import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.anotation.TopicName;
import org.apache.commons.lang3.StringUtils;

public class ExchangeRoutingNameStrategy {
    private ExchangeRoutingNameStrategy() {
        throw new IllegalStateException("Utility class");
    }

    public static String findExchangeName(Class<? extends FrameworkEvent> event, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        TopicName exchangeName = event.getAnnotation(TopicName.class);
        if (exchangeName != null) {
            return exchangeName.value();
        }
        if (StringUtils.isNotBlank((CharSequence)frameworkEventConfigProperties.getRabbitmq().getDefaultExchange())) {
            return frameworkEventConfigProperties.getRabbitmq().getDefaultExchange();
        }
        return event.getSimpleName();
    }

    public static String findRoutingKey(Class<? extends FrameworkEvent> event, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        return StringUtils.defaultString((String)frameworkEventConfigProperties.getRabbitmq().getRoutingKeyPrefix()) + event.getSimpleName() + StringUtils.defaultString((String)frameworkEventConfigProperties.getRabbitmq().getRoutingKeySuffix());
    }
}

