/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rabbitmq;

import com.cyberway.mp.bc.common.context.ServiceContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;

public class ReceiveMessagePostProcessor
implements MessagePostProcessor {
    private static final Set<String> ignoreHeaderSet = new HashSet<String>();

    public Message postProcessMessage(Message message) throws AmqpException {
        Map headers = message.getMessageProperties().getHeaders();
        ServiceContext context = ServiceContext.getContext();
        Map contextMap = context.getKeys();
        contextMap.clear();
        for (Map.Entry entry : headers.entrySet()) {
            if (ignoreHeaderSet.contains(entry.getKey())) continue;
            contextMap.put((String)entry.getKey(), entry.getValue());
        }
        return message;
    }

    static {
        ignoreHeaderSet.add("host");
        ignoreHeaderSet.add("accept-encoding");
        ignoreHeaderSet.add("user-agent");
        ignoreHeaderSet.add("accept");
        ignoreHeaderSet.add("__TypeId__");
        ignoreHeaderSet.add("x-death");
        ignoreHeaderSet.add("x-exception-message");
        ignoreHeaderSet.add("x-exception-stacktrace");
        ignoreHeaderSet.add("x-original-exchange");
        ignoreHeaderSet.add("x-original-routingKey");
        ignoreHeaderSet.add("x-first-death-reason");
        ignoreHeaderSet.add("x-first-death-queue");
        ignoreHeaderSet.add("x-first-death-exchange");
        ignoreHeaderSet.add("x-expires");
        ignoreHeaderSet.add("x-delay");
        ignoreHeaderSet.add("x-queue-type");
        ignoreHeaderSet.add("x-message-ttl");
        ignoreHeaderSet.add("x-routing-key");
    }
}

