/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.event.anotation.rocketmq.ListenerWrap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class EventRocketMQListenerContainer
implements InitializingBean,
RocketMQListenerContainer,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRocketMQListenerContainer.class);
    private ApplicationContext applicationContext;
    private String name;
    private long suspendCurrentQueueTimeMillis = 1000L;
    private int delayLevelWhenNextConsume = 0;
    private String nameServer;
    private AccessChannel accessChannel = AccessChannel.LOCAL;
    private String consumerGroup;
    private String topic;
    private int consumeThreadMax = 64;
    private String charset = "UTF-8";
    private MessageConverter messageConverter;
    private ListenerWrap listenerWrap;
    private DefaultMQPushConsumer consumer;
    private boolean running;
    private ConsumeMode consumeMode = ConsumeMode.CONCURRENTLY;
    private SelectorType selectorType = SelectorType.TAG;
    private String selectorExpression;
    private MessageModel messageModel = MessageModel.CLUSTERING;
    private long consumeTimeout = 15L;

    public void setListenerWrap(ListenerWrap listenerWrap) {
        this.listenerWrap = listenerWrap;
    }

    public long getSuspendCurrentQueueTimeMillis() {
        return this.suspendCurrentQueueTimeMillis;
    }

    public void setSuspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
        this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
    }

    public int getDelayLevelWhenNextConsume() {
        return this.delayLevelWhenNextConsume;
    }

    public void setDelayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
        this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public EventRocketMQListenerContainer setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        return this;
    }

    public ConsumeMode getConsumeMode() {
        return this.consumeMode;
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorExpression(String selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        LOGGER.info("container destroyed, {}", (Object)this);
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
        }
        this.setRunning(true);
        LOGGER.info("running container: {}", (Object)this);
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.consumer)) {
                this.consumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public void suspend() {
        this.consumer.suspend();
    }

    public void resume() {
        this.consumer.resume();
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initRocketMQPushConsumer();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String toString() {
        return "EventRocketMQListenerContainer{consumerGroup='" + this.consumerGroup + "', nameServer='" + this.nameServer + "', topic='" + this.topic + "', consumeMode=" + this.consumeMode + ", selectorType=" + this.selectorType + ", selectorExpression='" + this.selectorExpression + "', messageModel=" + this.messageModel + "}";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void handleMessage(MessageExt messageExt) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.listenerWrap.getTargetMethod().invoke(this.listenerWrap.getTargetBean(), this.doConvertMessage(messageExt));
    }

    private Object doConvertMessage(MessageExt messageExt) {
        Type messageType = this.listenerWrap.getMessageType();
        if (Objects.equals(messageType, MessageExt.class)) {
            return messageExt;
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(messageType, String.class)) {
            return str;
        }
        try {
            if (messageType instanceof Class) {
                return this.getMessageConverter().fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)messageType);
            }
            MethodParameter methodParameter = this.listenerWrap.getMethodParameter();
            return ((SmartMessageConverter)this.getMessageConverter()).fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)((ParameterizedType)messageType).getRawType(), (Object)methodParameter);
        }
        catch (Exception e) {
            LOGGER.info("convert failed. str:{}, msgType:{}", (Object)str, (Object)messageType);
            throw new BaseException("cannot convert message to " + messageType, (Throwable)e);
        }
    }

    private void initRocketMQPushConsumer() throws MQClientException {
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        LOGGER.debug("Access-key or secret-key not configure in {}.", (Object)this);
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup, false, null);
        this.consumer.setInstanceName(UtilAll.getPid() + "@" + System.currentTimeMillis());
        this.consumer.setNamesrvAddr(this.nameServer);
        if (this.accessChannel != null) {
            this.consumer.setAccessChannel(this.accessChannel);
        }
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        if (this.consumeThreadMax < this.consumer.getConsumeThreadMin()) {
            this.consumer.setConsumeThreadMin(this.consumeThreadMax);
        }
        this.consumer.setConsumeTimeout(this.consumeTimeout);
        switch (this.messageModel) {
            case BROADCASTING: {
                this.consumer.setMessageModel(org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel.BROADCASTING);
                break;
            }
            case CLUSTERING: {
                this.consumer.setMessageModel(org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel.CLUSTERING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'messageModel' was wrong.");
            }
        }
        switch (this.selectorType) {
            case TAG: {
                this.consumer.subscribe(this.topic, this.selectorExpression);
                break;
            }
            case SQL92: {
                this.consumer.subscribe(this.topic, MessageSelector.bySql((String)this.selectorExpression));
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'selectorType' was wrong.");
            }
        }
        switch (this.consumeMode) {
            case ORDERLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerOrderly());
                break;
            }
            case CONCURRENTLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'consumeMode' was wrong.");
            }
        }
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
            for (MessageExt messageExt : msgs) {
                LOGGER.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    EventRocketMQListenerContainer.this.handleMessage(messageExt);
                    long costTime = System.currentTimeMillis() - now;
                    LOGGER.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    LOGGER.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                    context.setSuspendCurrentQueueTimeMillis(EventRocketMQListenerContainer.this.suspendCurrentQueueTimeMillis);
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
            return ConsumeOrderlyStatus.SUCCESS;
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            for (MessageExt messageExt : msgs) {
                LOGGER.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    EventRocketMQListenerContainer.this.handleMessage(messageExt);
                    long costTime = System.currentTimeMillis() - now;
                    LOGGER.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    LOGGER.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                    context.setDelayLevelWhenNextConsume(EventRocketMQListenerContainer.this.delayLevelWhenNextConsume);
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

