/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.event.BaseFrameworkEventService;
import com.cyberway.mp.bc.event.ConfirmListener;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.service.rocketmq.TopicTagNameStrategy;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;

public class RocketMQFrameworkEventServiceImpl
extends BaseFrameworkEventService
implements FrameworkEventService {
    private static final String DESTINATION_SPE = ":";
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final RocketMQTemplate template;

    public RocketMQFrameworkEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, RocketMQTemplate template) {
        super(frameworkEventConfigProperties);
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.template = template;
    }

    @Override
    public void pushEvent(FrameworkEvent event) {
        this.pushEvent(event, null);
    }

    @Override
    public void pushEvent(FrameworkEvent event, String route) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        event.setSendTime(new Date());
        this.template.asyncSend(this.buildDestination(event, route), (Object)event, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(Throwable e) {
            }
        });
    }

    @Override
    public void pushEvent(final FrameworkEvent event, String route, final ConfirmListener callback) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        event.setSendTime(new Date());
        this.template.asyncSend(this.buildDestination(event, route), (Object)event, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                callback.onSuccess(event);
            }

            public void onException(Throwable e) {
                callback.onException(event, e);
            }
        });
    }

    private String buildDestination(FrameworkEvent event, String route) {
        String topic = TopicTagNameStrategy.findTopicName(event.getClass(), this.frameworkEventConfigProperties);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            return topic + DESTINATION_SPE + route;
        }
        return topic;
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        event.setSendTime(new Date());
        this.template.syncSend(this.buildDestination(event, route), (Object)event, timeout);
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route) {
        this.syncPushEvent(event, route, 3000L);
    }
}

