/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.event.service.rocketmq.EventRocketMQListenerContainer;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQMessageListenerConsumeConst;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQMessageListenerConcurrently
implements MessageListenerConcurrently {
    private int delayLevelWhenNextConsume = 0;
    private Class<? extends RocketMQListenerContainer> clazz;
    private RocketMQListenerContainer container;
    private static final Logger log = LoggerFactory.getLogger(RocketMQMessageListenerConcurrently.class);

    public RocketMQMessageListenerConcurrently(RocketMQListenerContainer container) {
        this.container = container;
        this.clazz = container.getClass();
        if (container instanceof DefaultRocketMQListenerContainer) {
            this.delayLevelWhenNextConsume = ((DefaultRocketMQListenerContainer)container).getDelayLevelWhenNextConsume();
        } else if (container instanceof EventRocketMQListenerContainer) {
            this.delayLevelWhenNextConsume = ((EventRocketMQListenerContainer)container).getDelayLevelWhenNextConsume();
        }
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        Set<String> ignoreHeaders = RocketMQMessageListenerConsumeConst.getIgnoreHeaders();
        for (MessageExt messageExt : msgs) {
            log.debug("received msg: {}", (Object)messageExt);
            try {
                RocketMQMessageListenerConsumeConst.consume(messageExt, ignoreHeaders, this.clazz, this.container, log);
            }
            catch (Exception e) {
                log.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                context.setDelayLevelWhenNextConsume(this.delayLevelWhenNextConsume);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }
}

