/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.common.context.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.slf4j.Logger;

public class RocketMQMessageListenerConsumeConst {
    private static Map<Class<? extends RocketMQListenerContainer>, Method> methodCache = new HashMap<Class<? extends RocketMQListenerContainer>, Method>();
    private static Set<String> ignoreHeaders = new HashSet<String>();

    public static Set<String> getIgnoreHeaders() {
        return ignoreHeaders;
    }

    private RocketMQMessageListenerConsumeConst() {
    }

    static void consume(MessageExt messageExt, Set<String> ignoreHeaders, Class<? extends RocketMQListenerContainer> clazz, RocketMQListenerContainer container, Logger log) throws InvocationTargetException, IllegalAccessException {
        long now = System.currentTimeMillis();
        ServiceContext.removeContext();
        ServiceContext sc = ServiceContext.getContext();
        for (Map.Entry entry : messageExt.getProperties().entrySet()) {
            if (ignoreHeaders.contains(((String)entry.getKey()).toUpperCase())) continue;
            sc.set((String)entry.getKey(), entry.getValue());
        }
        Method handleMessageMethod = methodCache.computeIfAbsent(clazz, a -> {
            Method method = null;
            try {
                method = a.getDeclaredMethod("handleMessage", MessageExt.class);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            return method;
        });
        handleMessageMethod.invoke((Object)container, messageExt);
        ServiceContext.removeContext();
        long costTime = System.currentTimeMillis() - now;
        log.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
    }

    static {
        ignoreHeaders.addAll(MessageConst.STRING_HASH_SET);
    }
}

