/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.event.service.rocketmq.EventRocketMQListenerContainer;
import com.cyberway.mp.bc.event.service.rocketmq.RocketMQMessageListenerConsumeConst;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQMessageListenerOrderly
implements MessageListenerOrderly {
    private long suspendCurrentQueueTimeMillis = 1000L;
    private Class<? extends RocketMQListenerContainer> clazz;
    private RocketMQListenerContainer container;
    private static final Logger log = LoggerFactory.getLogger(RocketMQMessageListenerOrderly.class);

    public RocketMQMessageListenerOrderly(RocketMQListenerContainer container) {
        this.container = container;
        this.clazz = container.getClass();
        if (container instanceof DefaultRocketMQListenerContainer) {
            this.suspendCurrentQueueTimeMillis = ((DefaultRocketMQListenerContainer)container).getSuspendCurrentQueueTimeMillis();
        } else if (container instanceof EventRocketMQListenerContainer) {
            this.suspendCurrentQueueTimeMillis = ((EventRocketMQListenerContainer)container).getSuspendCurrentQueueTimeMillis();
        }
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        Set<String> ignoreHeaders = RocketMQMessageListenerConsumeConst.getIgnoreHeaders();
        for (MessageExt messageExt : msgs) {
            log.debug("received msg: {}", (Object)messageExt);
            try {
                RocketMQMessageListenerConsumeConst.consume(messageExt, ignoreHeaders, this.clazz, this.container, log);
            }
            catch (Exception e) {
                log.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                context.setSuspendCurrentQueueTimeMillis(this.suspendCurrentQueueTimeMillis);
                return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
            }
        }
        return ConsumeOrderlyStatus.SUCCESS;
    }
}

