/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.TransactionEventService;
import com.cyberway.mp.bc.event.exception.TransactionRollBackException;
import com.cyberway.mp.bc.event.exception.TransactionUnkownException;
import com.cyberway.mp.bc.event.service.rocketmq.TopicTagNameStrategy;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.messaging.support.MessageBuilder;

public class RocketMQTransactionEventServiceImpl
implements TransactionEventService {
    private static final String DESTINATION_SPE = ":";
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final RocketMQTemplate template;

    public RocketMQTransactionEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, RocketMQTemplate template) {
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.template = template;
    }

    private String buildDestination(FrameworkEvent event, String route) {
        String topic = TopicTagNameStrategy.findTopicName(event.getClass(), this.frameworkEventConfigProperties);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            return topic + DESTINATION_SPE + route;
        }
        return topic;
    }

    @Override
    public void syncPushTransactionEvent(FrameworkEvent event, String route, Object businessArg) {
        event.setSendTime(new Date());
        TransactionSendResult result = this.template.sendMessageInTransaction(this.buildDestination(event, route), MessageBuilder.withPayload((Object)event).build(), businessArg);
        if (LocalTransactionState.UNKNOW.equals((Object)result.getLocalTransactionState())) {
            throw new TransactionUnkownException(" send status Unkown rocketmq msg id " + result.getMsgId());
        }
        if (LocalTransactionState.ROLLBACK_MESSAGE.equals((Object)result.getLocalTransactionState())) {
            throw new TransactionRollBackException(" send status rollback rocketmq msg id " + result.getMsgId());
        }
    }
}

