/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.common.message.MessageExt;

public class ServiceContextConsumeMessageHook
implements ConsumeMessageHook {
    private final Set<String> needDecodeSet = new HashSet<String>();

    public ServiceContextConsumeMessageHook(ContextProperties contextProperties) {
        if (null != contextProperties.getHeader() && null != contextProperties.getHeader().getNeedEncode()) {
            this.needDecodeSet.addAll(contextProperties.getHeader().getNeedDecode());
        }
    }

    public String hookName() {
        return "ServiceContextConsumeMessageHook";
    }

    public void consumeMessageBefore(ConsumeMessageContext context) {
        List msgList = context.getMsgList();
        for (MessageExt msg : msgList) {
            Map headers = msg.getProperties();
            for (Map.Entry entry : headers.entrySet()) {
                if (!this.needDecodeSet.contains(entry.getKey())) continue;
                entry.setValue(UrlCoderUtil.decoder((String)((String)entry.getValue())));
            }
        }
    }

    public void consumeMessageAfter(ConsumeMessageContext context) {
    }
}

