/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.rocketmq;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.hook.SendMessageContext;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.common.message.Message;

public class ServiceContextSendMessageHook
implements SendMessageHook {
    private final Set<String> needEncodeSet = new HashSet<String>();

    public ServiceContextSendMessageHook(ContextProperties contextProperties) {
        if (null != contextProperties.getHeader() && null != contextProperties.getHeader().getNeedEncode()) {
            this.needEncodeSet.addAll(contextProperties.getHeader().getNeedDecode());
        }
    }

    public String hookName() {
        return "ServiceContextSendMessageHook";
    }

    public void sendMessageBefore(SendMessageContext context) {
        Message msg = context.getMessage();
        Map headers = msg.getProperties();
        Map serviceContext = ServiceContext.getContext().getKeys();
        for (Map.Entry entry : serviceContext.entrySet()) {
            String value = String.valueOf(entry.getValue());
            headers.put((String)entry.getKey(), this.needEncodeSet.contains(entry.getKey()) ? UrlCoderUtil.encoder((String)value) : value);
        }
    }

    public void sendMessageAfter(SendMessageContext context) {
    }
}

