/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.servicebus;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.event.BaseFrameworkEventService;
import com.cyberway.mp.bc.event.ConfirmListener;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.service.servicebus.ServiceBusDestinationStrategy;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

public class ServiceBusFrameworkEventServiceImpl
extends BaseFrameworkEventService
implements FrameworkEventService {
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final JmsTemplate jmsTemplate;
    private final Logger logger = LoggerFactory.getLogger(ServiceBusFrameworkEventServiceImpl.class);

    public ServiceBusFrameworkEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, JmsTemplate jmsTemplate) {
        super(frameworkEventConfigProperties);
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    public void pushEvent(FrameworkEvent event) {
        this.pushEvent(event, null);
    }

    @Override
    public void pushEvent(FrameworkEvent event, String route) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        event.setSendTime(new Date());
        this.checkEnableRouteFilter(route);
        this.jmsTemplate.convertAndSend(ServiceBusDestinationStrategy.findTopicOrQueueName(event.getClass(), this.frameworkEventConfigProperties), (Object)event);
    }

    private void checkEnableRouteFilter(String route) {
        if (StringUtils.isBlank((CharSequence)route)) {
            return;
        }
        if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getServiceBus().getEnableRouteFilter())) {
            ServiceContext.getContext().setAttachment("cby_mp_service_bus_route_key", route);
        } else {
            this.logger.warn("service bus config [EnableRouteFilter] is false");
        }
    }

    @Override
    public void pushEvent(FrameworkEvent event, String route, ConfirmListener callback) {
        throw new UnsupportedOperationException("service bus not support callback");
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        throw new UnsupportedOperationException("service bus not support syncPushEvent");
    }

    @Override
    public void syncPushEvent(FrameworkEvent event, String route) {
        this.syncPushEvent(event, route, 0L);
    }
}

