/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.servicebus;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.agent.mq.servicebus.JmsMessagePropertyKeyUtils;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConversionException;

public class ServiceBusMappingJackson2MessageConverter
extends MappingJackson2MessageConverter {
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        Message message = super.toMessage(object, session);
        this.setContextToMessageProperties(message);
        return message;
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        ServiceContext.removeContext();
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            String decodeKey = JmsMessagePropertyKeyUtils.decode((String)key);
            Object objectProperty = message.getObjectProperty(key);
            if (null == objectProperty) continue;
            if (StringUtils.isNotBlank((CharSequence)decodeKey)) {
                ServiceContext.getContext().setAttachment(decodeKey, UrlCoderUtil.decoder((String)objectProperty.toString()));
                continue;
            }
            ServiceContext.getContext().setAttachment(key, UrlCoderUtil.decoder((String)objectProperty.toString()));
        }
        return super.fromMessage(message);
    }

    protected Message toMessage(Object object, Session session, ObjectWriter objectWriter) throws JMSException, MessageConversionException {
        Message message = super.toMessage(object, session, objectWriter);
        this.setContextToMessageProperties(message);
        return message;
    }

    private void setContextToMessageProperties(Message message) throws JMSException {
        ServiceContext sc = ServiceContext.getContext();
        for (Map.Entry entry : sc.getKeys().entrySet()) {
            message.setStringProperty(JmsMessagePropertyKeyUtils.encode((String)((String)entry.getKey())), UrlCoderUtil.encoder((String)entry.getValue().toString()));
        }
    }
}

