/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.spring;

import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.anotation.FrameworkEventHandler;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.config.SpringEventConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class SpringEventConsumerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void consumer(Object object) {
        if (SpringEventConfig.frameworkEventBeanMap != null && SpringEventConfig.frameworkEventBeanMap.size() > 0) {
            SpringEventConfig.frameworkEventBeanMap.forEach((beanName, bean) -> {
                FrameworkEventListener frameworkEventListener = bean.getClass().getAnnotation(FrameworkEventListener.class);
                if (frameworkEventListener == null) {
                    throw new IllegalArgumentException("\u4e8b\u4ef6\u5904\u7406\u9700\u8981\u4f7f\u7528@FrameworkEventListener");
                }
                Class<? extends FrameworkEvent> event = frameworkEventListener.value()[0];
                Method targetMethod = this.findTargetMethod(bean, event);
                if (event.isAssignableFrom(object.getClass())) {
                    try {
                        targetMethod.invoke(bean, object);
                    }
                    catch (Exception e) {
                        this.logger.error("spring \u4e8b\u4ef6\u6d88\u8d39error, message={}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
    }

    private Method findTargetMethod(Object bean, Type messageType) {
        AtomicReference targetMethodRef = new AtomicReference();
        ReflectionUtils.doWithMethods(bean.getClass(), method -> {
            FrameworkEventHandler eventHandler = (FrameworkEventHandler)AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class);
            if (eventHandler != null) {
                targetMethodRef.set(method);
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        Method method2 = (Method)targetMethodRef.get();
        if (method2.getParameters().length <= 0) {
            throw new IllegalArgumentException("listener \u5fc5\u8981\u6709\u4e8b\u4ef6\u53c2\u6570");
        }
        if (!messageType.equals(method2.getParameters()[0].getType())) {
            throw new IllegalArgumentException("listener\u4e8b\u4ef6\u53c2\u6570\u7c7b\u578b\u5fc5\u8981\u548c@FrameworkEventListener\u7684value\u7c7b\u578b\u76f8\u540c");
        }
        return method2;
    }
}

