/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.service.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.event.BaseFrameworkEventService;
import com.cyberway.mp.bc.event.ConfirmListener;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.event.SpringEventConfigProperties;
import com.cyberway.mp.bc.event.SpringFrameworkEvent;
import com.cyberway.mp.bc.event.client.SpringEventFeignClient;
import com.cyberway.mp.bc.retry.annotation.EnableRetry;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringEventProduderService
extends BaseFrameworkEventService
implements FrameworkEventService,
ApplicationContextAware {
    private static final ExecutorService EXECUTOR_SERVICE = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(5, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    private ApplicationContext applicationContext;
    private final SpringEventConfigProperties springEventConfigProperties;
    private SpringEventFeignClient springEventFeignClient;

    public SpringEventProduderService(SpringEventConfigProperties springEventConfigProperties, SpringEventFeignClient springEventFeignClient, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        super(frameworkEventConfigProperties);
        this.springEventConfigProperties = springEventConfigProperties;
        this.springEventFeignClient = springEventFeignClient;
    }

    @Override
    @EnableRetry(retryThrowable={Exception.class}, maxAttempt=3)
    public void pushEvent(FrameworkEvent event) {
        this.pushSpringEvent(event);
    }

    @Override
    @EnableRetry(retryThrowable={Exception.class}, maxAttempt=3)
    public void pushEvent(FrameworkEvent event, String route) {
        this.pushSpringEvent(event);
    }

    @Override
    @EnableRetry(retryThrowable={Exception.class}, maxAttempt=3)
    public void pushEvent(FrameworkEvent event, String route, ConfirmListener callback) {
        this.pushSpringEvent(event);
    }

    @Override
    @EnableRetry(async=true, retryThrowable={Exception.class}, maxAttempt=3)
    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        this.pushSpringEvent(event);
    }

    @Override
    @EnableRetry(async=true, retryThrowable={Exception.class}, maxAttempt=3)
    public void syncPushEvent(FrameworkEvent event, String route) {
        this.pushSpringEvent(event);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void pushSpringEvent(FrameworkEvent event) {
        if (this.isExcludeEvent(event)) {
            return;
        }
        List<String> consumerServices = this.springEventConfigProperties.getConsumerServices();
        if (consumerServices == null || consumerServices.isEmpty()) {
            this.applicationContext.publishEvent((Object)event);
        } else {
            for (String serviceName : consumerServices) {
                try {
                    EXECUTOR_SERVICE.submit(() -> {
                        try {
                            SpringFrameworkEvent springFrameworkEvent = new SpringFrameworkEvent(event.getClass().getName(), JSON.toJSONString((Object)event, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
                            return this.springEventFeignClient.consumer(new URI("http://" + serviceName), springFrameworkEvent);
                        }
                        catch (Exception e) {
                            throw new BaseException((Throwable)e);
                        }
                    }).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Thread.currentThread().interrupt();
                    throw new BaseException((Throwable)e);
                }
            }
        }
    }
}

