/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.Logger;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;

public class DMDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "dm";
    private Set<String> reservedWords = new HashSet<String>();

    public DMDatabase() {
        this.unquotedObjectsAreUppercased = true;
        super.setCurrentDateTimeFunction("SYSTIMESTAMP");
        this.dateFunctions.add(new DatabaseFunction("SYSDATE"));
        this.dateFunctions.add(new DatabaseFunction("SYSTIMESTAMP"));
        this.dateFunctions.add(new DatabaseFunction("CURRENT_TIMESTAMP"));
        this.sequenceNextValueFunction = "%s.nextval";
        this.sequenceCurrentValueFunction = "%s.currval";
    }

    public int getPriority() {
        return 5;
    }

    public void setConnection(DatabaseConnection conn) {
        this.reservedWords.addAll(Arrays.asList("GROUP", "USER", "SESSION", "PASSWORD", "RESOURCE", "START", "SIZE", "UID", "DESC", "ORDER", "DOMAIN", "CONTEXT"));
        Connection sqlConn = null;
        if (!(conn instanceof OfflineConnection)) {
            try {
                if (conn instanceof JdbcConnection) {
                    sqlConn = ((JdbcConnection)conn).getWrappedConnection();
                }
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
            if (sqlConn != null) {
                this.findReservedWords(sqlConn);
            }
        }
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.fine("DM databases reservedWords :" + Arrays.toString(this.reservedWords.toArray()));
        super.setConnection(conn);
    }

    private void findReservedWords(Connection sqlConn) {
        try {
            this.reservedWords.addAll(Arrays.asList(sqlConn.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*")));
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Could get sql keywords on DMDatabase: " + e.getMessage());
        }
    }

    public String getShortName() {
        return PRODUCT_NAME;
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 5236;
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return null;
    }

    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return this.correctObjectName(schema.getCatalogName() == null ? schema.getSchemaName() : schema.getCatalogName(), Schema.class);
    }

    protected String getAutoIncrementClause(String generationType, Boolean defaultOnNull) {
        return "IDENTITY";
    }

    public String generatePrimaryKeyName(String tableName) {
        return super.generatePrimaryKeyName(tableName);
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    public boolean isReservedWord(String objectName) {
        return this.reservedWords.contains(objectName.toUpperCase());
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsSchemas() {
        return false;
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        if (this.getConnection() instanceof OfflineConnection) {
            return this.getConnection().getCatalog();
        }
        if (!(this.getConnection() instanceof JdbcConnection)) {
            return this.defaultCatalogName;
        }
        try {
            return (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new RawCallStatement("select sys_context( 'userenv', 'current_schema' ) from dual"), String.class);
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error getting default schema", (Throwable)e);
            return null;
        }
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.fine("conn database product name :" + conn.getDatabaseProductName());
        return conn.getURL().startsWith("jdbc:dm:");
    }

    public String getDefaultDriver(String url) {
        return "dm.jdbc.driver.DmDriver";
    }

    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("iso date :" + normalLiteral);
        return normalLiteral;
    }

    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        String columnName;
        if (Column.class.isAssignableFrom(objectType) && (this.reservedWords.contains(columnName = objectName.toUpperCase()) || "SCHEMA".equals(columnName))) {
            return "\"" + objectName + "\"";
        }
        return super.escapeObjectName(objectName, objectType);
    }

    public boolean supportsTablespaces() {
        return true;
    }

    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    public boolean supportsNotNullConstraintNames() {
        return true;
    }
}

