/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.datatype;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import java.math.BigInteger;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.VarcharType;

@DataTypeInfo(name="varchar", aliases={"java.sql.Types.VARCHAR", "java.lang.String", "character varying", "varchar2"}, minParameters=0, maxParameters=1, priority=10)
public class DMBaseExtVarcharType
extends VarcharType {
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(Database database) {
        return database instanceof DMDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof DMDatabase) {
            Object[] parameters = this.getParameters();
            if (parameters.length != 1) {
                return new DatabaseDataType(database.escapeDataTypeName("VARCHAR"), new Object[]{"8188"});
            }
            String param1 = parameters[0].toString();
            if (param1.matches("\\d+") || param1.matches("\\d+\\s+CHAR")) {
                String[] parts = param1.split("\\s+");
                try {
                    BigInteger length = new BigInteger(parts[0]);
                    if (parts.length == 1) {
                        length = length.multiply(BigInteger.valueOf(3L));
                    }
                    if (length.compareTo(BigInteger.valueOf(32767L)) > 0) {
                        return new DatabaseDataType("TEXT");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return new DatabaseDataType(database.escapeDataTypeName("VARCHAR"), new Object[]{param1});
            }
            return new DatabaseDataType(database.escapeDataTypeName("VARCHAR"), new Object[]{"8188"});
        }
        return super.toDatabaseDataType(database);
    }
}

