/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.executor;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.listener.SqlListener;
import liquibase.logging.Logger;
import liquibase.sql.SqlConfiguration;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;

public class DMExecutor
extends JdbcExecutor {
    public boolean supports(Database database) {
        return database instanceof DMDatabase;
    }

    public int getPriority() {
        return 100;
    }

    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (this.database instanceof DMDatabase && sql instanceof InsertStatement) {
            this.execute(new ExecuteStatementCallback((InsertStatement)sql, sqlVisitors), sqlVisitors);
        } else {
            super.execute(sql, sqlVisitors);
        }
    }

    private boolean hasIdentity(Logger log, InsertStatement sql, Statement stmt) {
        String identitySql = "select IDENT_CURRENT('" + this.database.escapeTableName(sql.getCatalogName(), sql.getSchemaName(), sql.getTableName()) + "')";
        try {
            stmt.execute(identitySql);
            log.fine("select ident_current success ");
            return true;
        }
        catch (SQLException e) {
            log.fine("executor " + identitySql + " error:" + e.getMessage());
            return false;
        }
    }

    private void identityInsertOnOrOff(Logger log, InsertStatement sql, Statement stmt, boolean on) throws SQLException {
        String identityInsertSql = "SET IDENTITY_INSERT " + this.database.escapeTableName(sql.getCatalogName(), sql.getSchemaName(), sql.getTableName());
        identityInsertSql = on ? identityInsertSql + " ON" : identityInsertSql + " OFF";
        stmt.execute(identityInsertSql);
        log.fine(" executor " + identityInsertSql + " success ");
    }

    private void identityInsertOn(Logger log, InsertStatement sql, Statement stmt) throws SQLException {
        this.identityInsertOnOrOff(log, sql, stmt, true);
    }

    private void identityInsertOff(Logger log, InsertStatement sql, Statement stmt) throws SQLException {
        this.identityInsertOnOrOff(log, sql, stmt, false);
    }

    private String getErrorCode(Throwable e) {
        if (e instanceof SQLException) {
            return "(" + ((SQLException)e).getErrorCode() + ") ";
        }
        return "";
    }

    public Object execute(ExecuteStatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Executing with the '" + this.getName() + "' executor");
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            if (con instanceof OfflineConnection) {
                throw new DatabaseException("Cannot execute commands against an offline database");
            }
            Statement stmtToUse = stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
            object = action.doInStatement(stmtToUse);
        }
        catch (SQLException ex) {
            try {
                JdbcUtil.closeStatement(stmt);
                stmt = null;
                String url = con.isClosed() ? "CLOSED CONNECTION" : con.getURL();
                throw new DatabaseException("Error executing SQL " + StringUtil.join((String[])this.applyVisitors(action.getStatement(), sqlVisitors), (String)("; on " + url)) + ": " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtil.closeStatement((Statement)stmt);
        return object;
    }

    private class ExecuteStatementCallback {
        private final InsertStatement sql;
        private final List<SqlVisitor> sqlVisitors;

        private ExecuteStatementCallback(InsertStatement sql, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.sqlVisitors = sqlVisitors;
        }

        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            boolean hasIdentity = DMExecutor.this.hasIdentity(log, this.sql, stmt);
            for (String statement : DMExecutor.this.applyVisitors((SqlStatement)this.sql, this.sqlVisitors)) {
                for (SqlListener listener : Scope.getCurrentScope().getListeners(SqlListener.class)) {
                    listener.writeSqlWillRun(String.format("%s", statement));
                }
                Level sqlLogLevel = (Level)SqlConfiguration.SHOW_AT_LOG_LEVEL.getCurrentValue();
                log.log(sqlLogLevel, statement, null);
                if (statement.contains("?")) {
                    stmt.setEscapeProcessing(false);
                }
                try {
                    if (hasIdentity) {
                        DMExecutor.this.identityInsertOn(log, this.sql, stmt);
                    }
                    this.execute(stmt, log, sqlLogLevel, statement);
                    if (hasIdentity) {
                        DMExecutor.this.identityInsertOff(log, this.sql, stmt);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseException(e.getMessage() + " [Failed SQL: " + DMExecutor.this.getErrorCode(e) + statement + "]", (Throwable)e);
                }
                try {
                    int updateCount = 0;
                    do {
                        if (stmt.getMoreResults() || (updateCount = stmt.getUpdateCount()) == -1) continue;
                        log.log(sqlLogLevel, updateCount + " row(s) affected", null);
                    } while (updateCount != -1);
                }
                catch (Exception e) {
                    throw new DatabaseException(e.getMessage() + " [Failed SQL: " + DMExecutor.this.getErrorCode(e) + statement + "]", (Throwable)e);
                }
            }
            return null;
        }

        private void execute(Statement stmt, Logger log, Level sqlLogLevel, String statement) throws SQLException {
            if (!stmt.execute(statement)) {
                log.log(sqlLogLevel, stmt.getUpdateCount() + " row(s) affected", null);
            }
        }

        public SqlStatement getStatement() {
            return this.sql;
        }
    }
}

