/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.snapshotgenerator;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.RowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.TableSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMTableSnapshotGenerator
extends TableSnapshotGenerator {
    private static final String SQL_FILTER_MATCH_ALL = "%";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        if (database instanceof DMDatabase) {
            Schema schema = example.getSchema();
            String tableName = example.getName();
            DatabaseMetaData databaseMetaData = null;
            if (database.getConnection() != null) {
                List<CachedRow> rs = null;
                try {
                    databaseMetaData = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().getMetaData();
                    String catalog = ((AbstractJdbcDatabase)database).getJdbcCatalogName(schema);
                    String schemaName = ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema);
                    ResultSet resultSet = databaseMetaData.getTables(catalog, this.escapeForLike(schemaName, database), tableName == null ? SQL_FILTER_MATCH_ALL : this.escapeForLike(tableName, database), new String[]{"TABLE"});
                    rs = this.extract(database, resultSet, false);
                    if (rs.isEmpty()) {
                        return null;
                    }
                    Table table = this.readTable(rs.get(0), database);
                    return table;
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.snapshotObject(example, snapshot);
    }

    private String escapeForLike(String name, Database database) {
        if (name == null) {
            return null;
        }
        if (database instanceof SQLiteDatabase) {
            return name;
        }
        return name.replace(SQL_FILTER_MATCH_ALL, "!%").replace("_", "!_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CachedRow> extract(final Database database, ResultSet resultSet, final boolean informixIndexTrimHint) throws SQLException {
        resultSet.setFetchSize(database.getFetchSize());
        ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
        try {
            List result = (List)new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(){

                protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
                    Object value = super.getColumnValue(rs, index);
                    if (value instanceof String) {
                        if (!informixIndexTrimHint) {
                            value = ((String)value).trim();
                        } else {
                            boolean startsWithSpace = false;
                            if (database instanceof InformixDatabase && ((String)value).matches("^ .*$")) {
                                startsWithSpace = true;
                            }
                            value = ((String)value).trim();
                            if (startsWithSpace) {
                                value = " " + value;
                            }
                        }
                    }
                    return value;
                }
            }).extractData(resultSet);
            for (Map row : result) {
                returnList.add(new CachedRow(row));
            }
        }
        finally {
            JdbcUtil.closeResultSet((ResultSet)resultSet);
        }
        return returnList;
    }
}

