/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import java.util.Date;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.InsertStatement;

public class DMInsertGenerator
extends InsertGenerator {
    public boolean supports(InsertStatement statement, Database database) {
        return database instanceof DMDatabase;
    }

    public int getPriority() {
        return 10;
    }

    public void generateValues(StringBuilder sql, InsertStatement statement, Database database) {
        sql.append("(");
        for (String column : statement.getColumnValues().keySet()) {
            Object newValue = statement.getColumnValues().get(column);
            if (newValue == null || "NULL".equalsIgnoreCase(newValue.toString())) {
                sql.append("NULL");
            } else if (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, database)) {
                this.handlerString(sql, newValue, database);
            } else if (newValue instanceof Date) {
                sql.append(database.getDateLiteral((Date)newValue));
            } else if (newValue instanceof Boolean) {
                if (Boolean.TRUE.equals(newValue)) {
                    sql.append(DataTypeFactory.getInstance().getTrueBooleanValue(database));
                } else {
                    sql.append(DataTypeFactory.getInstance().getFalseBooleanValue(database));
                }
            } else if (newValue instanceof DatabaseFunction) {
                sql.append(database.generateDatabaseFunctionValue((DatabaseFunction)newValue));
            } else {
                sql.append(newValue);
            }
            sql.append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        int lastComma = sql.lastIndexOf(",");
        if (lastComma >= 0) {
            sql.deleteCharAt(lastComma);
        }
        sql.append(")");
    }

    private void handlerString(StringBuilder sql, Object newValue, Database database) {
        if (this.isISODateTime(newValue.toString())) {
            sql.append("'" + newValue.toString().replace('T', ' ') + "'");
        } else if (this.isISOShortDateTime(newValue.toString())) {
            sql.append("'" + newValue.toString().replace('T', ' ') + "'");
        } else {
            sql.append(DataTypeFactory.getInstance().fromObject(newValue, database).objectToSql(newValue, database));
        }
    }

    private boolean isISODateTime(String isoDate) {
        return isoDate.matches("^\\d{4}\\-\\d{2}\\-\\d{2}[T ]\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?$") || isoDate.matches("^\\d{4}\\-\\d{2}\\-\\d{1}[T ]\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?$");
    }

    private boolean isISOShortDateTime(String isoShortDate) {
        return isoShortDate.matches("^\\d{4}\\-\\d{2}\\-\\d{2}[T ]\\d{2}:\\d{2}$");
    }
}

