/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

public class DMModifyDataTypeGenerator
extends AbstractSqlGenerator<ModifyDataTypeStatement> {
    public boolean supports(ModifyDataTypeStatement statement, Database database) {
        return database instanceof DMDatabase;
    }

    public int getPriority() {
        return 10;
    }

    public Warnings warn(ModifyDataTypeStatement modifyDataTypeStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Warnings warnings = super.warn((SqlStatement)modifyDataTypeStatement, database, sqlGeneratorChain);
        if (database instanceof MySQLDatabase && !modifyDataTypeStatement.getNewDataType().toLowerCase().contains("varchar")) {
            warnings.addWarning("modifyDataType will lose primary key/autoincrement/not null settings for mysql.  Use <sql> and re-specify all configuration if this is the case");
        }
        return warnings;
    }

    public ValidationErrors validate(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("columnName", (Object)statement.getColumnName());
        validationErrors.checkRequiredField("newDataType", (Object)statement.getNewDataType());
        return validationErrors;
    }

    public Sql[] generateSql(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        alterTable = alterTable + " " + this.getModifyString(database) + " ";
        String columnName = database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        alterTable = alterTable + columnName;
        alterTable = alterTable + this.getPreDataTypeString(database);
        DatabaseDataType newDataType = DataTypeFactory.getInstance().fromDescription(statement.getNewDataType(), database).toDatabaseDataType(database);
        alterTable = alterTable + newDataType;
        if (database instanceof PostgresDatabase) {
            alterTable = alterTable + " USING (" + columnName + "::" + newDataType + ")";
        }
        return new Sql[]{new UnparsedSql(alterTable, new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    protected Relation getAffectedTable(ModifyDataTypeStatement statement) {
        return new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName());
    }

    protected String getModifyString(Database database) {
        return "MODIFY";
    }

    protected String getPreDataTypeString(Database database) {
        return " ";
    }
}

