/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class DMSetColumnRemarksGenerator
extends AbstractSqlGenerator<SetColumnRemarksStatement> {
    public int getPriority() {
        return 1;
    }

    public boolean supports(SetColumnRemarksStatement statement, Database database) {
        return database instanceof DMDatabase;
    }

    public ValidationErrors validate(SetColumnRemarksStatement setColumnRemarksStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)setColumnRemarksStatement.getTableName());
        validationErrors.checkRequiredField("columnName", (Object)setColumnRemarksStatement.getColumnName());
        validationErrors.checkDisallowedField("catalogName", (Object)setColumnRemarksStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        if (database instanceof MySQLDatabase) {
            validationErrors.checkRequiredField("columnDataType", (Object)StringUtil.trimToNull((String)setColumnRemarksStatement.getColumnDataType()));
        }
        return validationErrors;
    }

    public Sql[] generateSql(SetColumnRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String remarksEscaped = database.escapeStringForDatabase(StringUtil.trimToEmpty((String)statement.getRemarks()));
        if (database instanceof MySQLDatabase) {
            return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " MODIFY COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " " + DataTypeFactory.getInstance().fromDescription(statement.getColumnDataType(), database).toDatabaseDataType(database) + " COMMENT '" + remarksEscaped + "'", new DatabaseObject[]{this.getAffectedColumn(statement)})};
        }
        if (database instanceof MSSQLDatabase) {
            String schemaName = statement.getSchemaName();
            if (schemaName == null) {
                schemaName = database.getDefaultSchemaName();
            }
            if (schemaName == null) {
                schemaName = "dbo";
            }
            Sql[] generatedSql = new Sql[]{new UnparsedSql("DECLARE @TableName SYSNAME set @TableName = N'" + statement.getTableName() + "'; DECLARE @FullTableName SYSNAME set @FullTableName = N'" + schemaName + "." + statement.getTableName() + "'; DECLARE @ColumnName SYSNAME set @ColumnName = N'" + statement.getColumnName() + "'; DECLARE @MS_DescriptionValue NVARCHAR(3749); SET @MS_DescriptionValue = N'" + remarksEscaped + "';DECLARE @MS_Description NVARCHAR(3749) set @MS_Description = NULL; SET @MS_Description = (SELECT CAST(Value AS NVARCHAR(3749)) AS [MS_Description] FROM sys.extended_properties AS ep WHERE ep.major_id = OBJECT_ID(@FullTableName) AND ep.minor_id=COLUMNPROPERTY(ep.major_id, @ColumnName, 'ColumnId') AND ep.name = N'MS_Description'); IF @MS_Description IS NULL BEGIN EXEC sys.sp_addextendedproperty @name  = N'MS_Description', @value = @MS_DescriptionValue, @level0type = N'SCHEMA', @level0name = N'" + schemaName + "', @level1type = N'TABLE', @level1name = @TableName, @level2type = N'COLUMN', @level2name = @ColumnName; END ELSE BEGIN EXEC sys.sp_updateextendedproperty @name  = N'MS_Description', @value = @MS_DescriptionValue, @level0type = N'SCHEMA', @level0name = N'" + schemaName + "', @level1type = N'TABLE', @level1name = @TableName, @level2type = N'COLUMN', @level2name = @ColumnName; END", new DatabaseObject[0])};
            return generatedSql;
        }
        return new Sql[]{new UnparsedSql("COMMENT ON COLUMN " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + "." + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " IS '" + remarksEscaped + "'", new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }

    protected Column getAffectedColumn(SetColumnRemarksStatement statement) {
        return new Column().setName(statement.getColumnName()).setRelation(new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName()));
    }
}

