/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.dm.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.dm.database.DMDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class DMSetNullableGenerator
extends AbstractSqlGenerator<SetNullableStatement> {
    public int getPriority() {
        return 10;
    }

    public boolean supports(SetNullableStatement statement, Database database) {
        return database instanceof DMDatabase;
    }

    public ValidationErrors validate(SetNullableStatement setNullableStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)setNullableStatement.getTableName());
        if (setNullableStatement.isNullable()) {
            if (setNullableStatement.getConstraintName() == null && setNullableStatement.getColumnName() == null) {
                validationErrors.addError("Oracle requires either constraintName or columnName to be set");
            }
        } else {
            validationErrors.checkRequiredField("columnName", (Object)setNullableStatement.getColumnName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(SetNullableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Sql[] a;
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + (statement.isNullable() ? " SET NULL" : " SET NOT NULL");
        ArrayList<Object> returnList = new ArrayList<Object>();
        returnList.add(new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedColumn(statement)}));
        if (database instanceof DB2Database && (a = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)new ReorganizeTableStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()), database)) != null) {
            returnList.addAll(Arrays.asList(a));
        }
        return returnList.toArray(new Sql[returnList.size()]);
    }

    protected Column getAffectedColumn(SetNullableStatement statement) {
        return new Column().setName(statement.getColumnName()).setRelation(new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName()));
    }
}

