/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.mssql.datatype;

import java.math.BigInteger;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.VarcharType;

@DataTypeInfo(name="varchar", aliases={"text", "mediumtext", "longtext", "", "java.sql.Types.VARCHAR", "java.lang.String", "varchar2", "character varying"}, minParameters=0, maxParameters=1, priority=10)
public class MssqlExtVarcharType
extends VarcharType {
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof MSSQLDatabase) {
            String param1;
            Object[] parameters = this.getParameters();
            if (!(parameters.length <= 0 || (param1 = parameters[0].toString()).matches("\\d+") && new BigInteger(param1).compareTo(BigInteger.valueOf(4000L)) <= 0)) {
                DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("nvarchar"), new Object[]{"MAX"});
                type.addAdditionalInformation(this.getAdditionalInformation());
                return type;
            }
            if (parameters.length == 0) {
                parameters = new Object[]{"MAX"};
            } else if (parameters.length > 1) {
                parameters = Arrays.copyOfRange(parameters, 0, 1);
            }
            DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("nvarchar"), parameters);
            type.addAdditionalInformation(this.getAdditionalInformation());
            return type;
        }
        return super.toDatabaseDataType(database);
    }
}

