/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.mssql.executor;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.listener.SqlListener;
import liquibase.logging.Logger;
import liquibase.sql.SqlConfiguration;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;

public class MssqlExecutor
extends JdbcExecutor {
    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }

    public int getPriority() {
        return 200;
    }

    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof AddColumnStatement) {
            this.execute(new ExecuteStatementCallback((AddColumnStatement)sql, sqlVisitors), sqlVisitors);
        } else {
            super.execute(sql, sqlVisitors);
        }
    }

    private String getErrorCode(Throwable e) {
        if (e instanceof SQLException) {
            return "(" + ((SQLException)e).getErrorCode() + ") ";
        }
        return "";
    }

    public Object execute(ExecuteStatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Executing with the '" + this.getName() + "' executor");
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            if (con instanceof OfflineConnection) {
                throw new DatabaseException("Cannot execute commands against an offline database");
            }
            Statement stmtToUse = stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
            object = action.doInStatement(stmtToUse);
        }
        catch (SQLException ex) {
            try {
                JdbcUtil.closeStatement(stmt);
                stmt = null;
                String url = con.isClosed() ? "CLOSED CONNECTION" : con.getURL();
                throw new DatabaseException("Error executing SQL " + StringUtil.join((String[])this.applyVisitors(action.getStatement(), sqlVisitors), (String)("; on " + url)) + ": " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtil.closeStatement((Statement)stmt);
        return object;
    }

    private class ExecuteStatementCallback {
        private final AddColumnStatement sql;
        private final List<SqlVisitor> sqlVisitors;

        private ExecuteStatementCallback(AddColumnStatement sql, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.sqlVisitors = sqlVisitors;
        }

        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            String[] statements = MssqlExecutor.this.applyVisitors((SqlStatement)this.sql, this.sqlVisitors);
            for (int i = 0; i < statements.length; ++i) {
                String statement = statements[i];
                for (SqlListener listener : Scope.getCurrentScope().getListeners(SqlListener.class)) {
                    listener.writeSqlWillRun(String.format("%s", statement));
                }
                Level sqlLogLevel = (Level)SqlConfiguration.SHOW_AT_LOG_LEVEL.getCurrentValue();
                log.log(sqlLogLevel, statement, null);
                if (statement.contains("?")) {
                    stmt.setEscapeProcessing(false);
                }
                try {
                    this.execute(stmt, log, sqlLogLevel, statement);
                    AddColumnStatement column = this.sql;
                    if (column.getDefaultValue() != null && column.isNullable()) {
                        String[] sqlSplit = statement.toUpperCase().split(" DEFAULT ");
                        String defaultValue = sqlSplit[sqlSplit.length - 1];
                        String updateSql = "update " + MssqlExecutor.this.database.escapeTableName(column.getCatalogName(), column.getSchemaName(), column.getTableName()) + " set " + MssqlExecutor.this.database.escapeColumnName(column.getCatalogName(), column.getSchemaName(), column.getTableName(), column.getColumnName()) + " = " + defaultValue;
                        stmt.execute(updateSql);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseException(e.getMessage() + " [Failed SQL: " + MssqlExecutor.this.getErrorCode(e) + statement + "]", (Throwable)e);
                }
                try {
                    int updateCount = 0;
                    do {
                        if (stmt.getMoreResults() || (updateCount = stmt.getUpdateCount()) == -1) continue;
                        log.log(sqlLogLevel, updateCount + " row(s) affected", null);
                    } while (updateCount != -1);
                    continue;
                }
                catch (Exception e) {
                    throw new DatabaseException(e.getMessage() + " [Failed SQL: " + MssqlExecutor.this.getErrorCode(e) + statement + "]", (Throwable)e);
                }
            }
            return null;
        }

        private void execute(Statement stmt, Logger log, Level sqlLogLevel, String statement) throws SQLException {
            if (!stmt.execute(statement)) {
                log.log(sqlLogLevel, stmt.getUpdateCount() + " row(s) affected", null);
            }
        }

        public SqlStatement getStatement() {
            return this.sql;
        }
    }
}

