/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.core.AddColumnStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class OracleAddColumnGenerator
extends AddColumnGenerator {
    private static final Pattern PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}$");

    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Sql[] generateSql(AddColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        if (statement.isMultiple()) {
            return this.generateMultipleColumns(statement.getColumns(), database);
        }
        return this.generateSingleColumn(statement, database);
    }

    protected String generateSingleColumnSQL(AddColumnStatement statement, Database database) {
        DatabaseDataType columnType = null;
        if (statement.getColumnType() != null) {
            columnType = DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database).toDatabaseDataType(database);
        }
        StringBuilder alterTable = new StringBuilder(" ADD " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()));
        if (columnType != null) {
            alterTable.append(" ").append(columnType);
        }
        if (statement.isAutoIncrement() && database.supportsAutoIncrement()) {
            AutoIncrementConstraint autoIncrementConstraint = statement.getAutoIncrementConstraint();
            alterTable.append(" ").append(database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy(), autoIncrementConstraint.getGenerationType(), autoIncrementConstraint.getDefaultOnNull()));
        }
        Object defaultValue = statement.getDefaultValue();
        alterTable.append(this.getDefaultClause(statement, database));
        if (!statement.isNullable()) {
            for (ColumnConstraint constraint : statement.getConstraints()) {
                NotNullConstraint notNullConstraint;
                if (!(constraint instanceof NotNullConstraint) || !StringUtil.isNotEmpty((String)(notNullConstraint = (NotNullConstraint)constraint).getConstraintName())) continue;
                alterTable.append(" CONSTRAINT ").append(database.escapeConstraintName(notNullConstraint.getConstraintName()));
                break;
            }
            if (null == columnType || !columnType.toString().toUpperCase().contains("VARCHAR") || null != defaultValue && !StringUtil.isEmpty((String)defaultValue.toString())) {
                alterTable.append(" NOT NULL");
            }
            if (database instanceof OracleDatabase) {
                alterTable.append(!statement.shouldValidateNullable() ? " ENABLE NOVALIDATE " : "");
            }
        } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase || database instanceof MySQLDatabase || database instanceof MSSQLDatabase && columnType != null && "timestamp".equalsIgnoreCase(columnType.toString())) {
            alterTable.append(" NULL");
        }
        if (statement.isPrimaryKey()) {
            alterTable.append(" PRIMARY KEY");
            if (database instanceof OracleDatabase) {
                alterTable.append(!statement.shouldValidatePrimaryKey() ? " ENABLE NOVALIDATE " : "");
            }
        }
        if (database instanceof MySQLDatabase && statement.getRemarks() != null) {
            alterTable.append(" COMMENT '").append(database.escapeStringForDatabase(StringUtil.trimToEmpty((String)statement.getRemarks()))).append("' ");
        }
        if (statement.getAddAfterColumn() != null && !statement.getAddAfterColumn().isEmpty()) {
            alterTable.append(" AFTER `").append(statement.getAddAfterColumn()).append("` ");
        }
        return alterTable.toString();
    }

    private Sql[] generateMultipleColumns(List<AddColumnStatement> columns, Database database) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (database instanceof MySQLDatabase) {
            StringBuilder alterTable = new StringBuilder(this.generateSingleColumBaseSQL(columns.get(0), database));
            for (int i = 0; i < columns.size(); ++i) {
                alterTable.append(this.generateSingleColumnSQL(columns.get(i), database));
                if (i >= columns.size() - 1) continue;
                alterTable.append(",");
            }
            result.add(new UnparsedSql(alterTable.toString(), (DatabaseObject[])this.getAffectedColumns(columns)));
            for (AddColumnStatement statement : columns) {
                this.addUniqueConstraintStatements(statement, database, result);
                this.addForeignKeyStatements(statement, database, result);
            }
        } else {
            for (AddColumnStatement column : columns) {
                result.addAll(Arrays.asList(this.generateSingleColumn(column, database)));
            }
        }
        return result.toArray(new Sql[result.size()]);
    }

    private String getDefaultClause(AddColumnStatement statement, Database database) {
        Object clause = "";
        Object defaultValue = statement.getDefaultValue();
        String columnType = statement.getColumnType().toLowerCase();
        if (defaultValue != null) {
            if (database instanceof OracleDatabase && ("datetime".equalsIgnoreCase(columnType) || "date".equalsIgnoreCase(columnType) || "timestamp".equalsIgnoreCase(columnType)) && this.matchTimestampValue(defaultValue.toString())) {
                clause = (String)clause + " DEFAULT " + String.format("TO_TIMESTAMP('%s','yyyy-mm-dd\"T\"hh24:mi:ss')", defaultValue);
            } else if (database instanceof OracleDatabase && defaultValue.toString().startsWith("GENERATED ALWAYS ")) {
                clause = (String)clause + " " + DataTypeFactory.getInstance().fromObject(defaultValue, database).objectToSql(defaultValue, database);
            } else {
                if (database instanceof MSSQLDatabase) {
                    String constraintName = statement.getDefaultValueConstraintName();
                    if (constraintName == null) {
                        constraintName = ((MSSQLDatabase)database).generateDefaultConstraintName(statement.getTableName(), statement.getColumnName());
                    }
                    clause = (String)clause + " CONSTRAINT " + constraintName;
                }
                clause = defaultValue instanceof DatabaseFunction ? (String)clause + " DEFAULT " + DataTypeFactory.getInstance().fromObject(defaultValue, database).objectToSql(defaultValue, database) : (String)clause + " DEFAULT " + DataTypeFactory.getInstance().fromDescription(statement.getColumnType(), database).objectToSql(defaultValue, database);
            }
        }
        return clause;
    }

    private boolean matchTimestampValue(String str) {
        Matcher m = PATTERN.matcher(str);
        return m.matches();
    }
}

