/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.oracle.utils.OracleDatabaseUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class OracleCreateTableGenerator
extends CreateTableGenerator {
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(CreateTableStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    /*
     * WARNING - void declaration
     */
    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        OracleDatabaseUtils.addAdditionReserveWords((OracleDatabase)database);
        ArrayList<UnparsedSql> additionalSql = new ArrayList<UnparsedSql>();
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE TABLE ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" ");
        buffer.append("(");
        boolean isSinglePrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().size() == 1;
        boolean isPrimaryKeyAutoIncrement = false;
        Iterator columnIterator = statement.getColumns().iterator();
        while (columnIterator.hasNext()) {
            void var12_12;
            String column = (String)columnIterator.next();
            DatabaseDataType columnType = null;
            if (statement.getColumnTypes().get(column) != null) {
                columnType = ((LiquibaseDataType)statement.getColumnTypes().get(column)).toDatabaseDataType(database);
            }
            String targetColumn = column;
            if (database.isReservedWord(column.toUpperCase())) {
                targetColumn = column.toUpperCase();
            }
            if (columnType == null) {
                buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), targetColumn, false));
            } else {
                buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), targetColumn, !statement.isComputed(column)));
                buffer.append(" ").append(columnType);
            }
            Object var12_13 = null;
            for (AutoIncrementConstraint currentAutoIncrementConstraint : statement.getAutoIncrementConstraints()) {
                if (!column.equals(currentAutoIncrementConstraint.getColumnName())) continue;
                AutoIncrementConstraint autoIncrementConstraint = currentAutoIncrementConstraint;
                break;
            }
            boolean isAutoIncrementColumn = var12_12 != null;
            boolean isPrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().contains(column);
            isPrimaryKeyAutoIncrement = isPrimaryKeyAutoIncrement || isPrimaryKeyColumn && isAutoIncrementColumn;
            Object defaultValue = null;
            if (columnType != null && !columnType.isAutoIncrement() && statement.getDefaultValue(column) != null) {
                defaultValue = statement.getDefaultValue(column);
                if (statement.getDefaultValue(column).toString().startsWith("GENERATED ALWAYS ")) {
                    buffer.append(" ");
                } else if (statement.getDefaultValue(column).toString().contains("IDENTITY GENERATED BY DEFAULT")) {
                    buffer.append(" ");
                } else {
                    buffer.append(" DEFAULT ");
                }
                if (defaultValue instanceof DatabaseFunction) {
                    buffer.append(database.generateDatabaseFunctionValue((DatabaseFunction)defaultValue));
                } else {
                    buffer.append(((LiquibaseDataType)statement.getColumnTypes().get(column)).objectToSql(defaultValue, database));
                }
            }
            if (isAutoIncrementColumn) {
                if (database.supportsAutoIncrement()) {
                    String autoIncrementClause = database.getAutoIncrementClause(var12_12.getStartWith(), var12_12.getIncrementBy(), var12_12.getGenerationType(), var12_12.getDefaultOnNull());
                    if (!"".equals(autoIncrementClause)) {
                        buffer.append(" ").append(autoIncrementClause);
                    }
                } else {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(database.getShortName() + " does not support autoincrement columns as requested for " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
                }
            }
            if (statement.getNotNullColumns().get(column) != null) {
                if (null != columnType && columnType.toString().toUpperCase().contains("VARCHAR") && (null == defaultValue || StringUtil.isEmpty((String)defaultValue.toString()))) {
                    buffer.append("");
                } else if (!database.supportsNotNullConstraintNames()) {
                    buffer.append(" NOT NULL");
                } else {
                    NotNullConstraint nnConstraintForThisColumn = (NotNullConstraint)statement.getNotNullColumns().get(column);
                    String nncName = StringUtil.trimToNull((String)nnConstraintForThisColumn.getConstraintName());
                    if (nncName == null) {
                        buffer.append(" NOT NULL");
                    } else {
                        buffer.append(" CONSTRAINT ");
                        buffer.append(database.escapeConstraintName(nncName));
                        buffer.append(" NOT NULL");
                    }
                    if (!nnConstraintForThisColumn.shouldValidateNullable()) {
                        buffer.append(" ENABLE NOVALIDATE ");
                    }
                }
            }
            if (!columnIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(",");
        if ((isSinglePrimaryKeyColumn || isPrimaryKeyAutoIncrement) && statement.getPrimaryKeyConstraint() != null && !statement.getPrimaryKeyConstraint().getColumns().isEmpty()) {
            if (database.supportsPrimaryKeyNames()) {
                Object pkName = StringUtil.trimToNull((String)statement.getPrimaryKeyConstraint().getConstraintName());
                if (pkName == null) {
                    pkName = database.generatePrimaryKeyName(statement.getTableName());
                }
                if (pkName != null) {
                    buffer.append(" CONSTRAINT ");
                    buffer.append(database.escapeConstraintName((String)pkName));
                }
            }
            buffer.append(" PRIMARY KEY (");
            buffer.append(database.escapeColumnNameList(StringUtil.join((Collection)statement.getPrimaryKeyConstraint().getColumns(), (String)", ")));
            buffer.append(")");
            if (statement.getPrimaryKeyConstraint().getTablespace() != null) {
                buffer.append(" USING INDEX TABLESPACE ");
                buffer.append(statement.getPrimaryKeyConstraint().getTablespace());
            }
            buffer.append(!statement.getPrimaryKeyConstraint().shouldValidatePrimaryKey() ? " ENABLE NOVALIDATE " : "");
            if (database.supportsInitiallyDeferrableColumns()) {
                if (statement.getPrimaryKeyConstraint().isInitiallyDeferred()) {
                    buffer.append(" INITIALLY DEFERRED");
                }
                if (statement.getPrimaryKeyConstraint().isDeferrable()) {
                    buffer.append(" DEFERRABLE");
                }
            }
            buffer.append(",");
        }
        for (ForeignKeyConstraint fkConstraint : statement.getForeignKeyConstraints()) {
            buffer.append(" CONSTRAINT ");
            buffer.append(database.escapeConstraintName(fkConstraint.getForeignKeyName()));
            Object referencesString = fkConstraint.getReferences();
            buffer.append(" FOREIGN KEY (").append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), fkConstraint.getColumn())).append(") REFERENCES ");
            if (referencesString != null) {
                if (!((String)referencesString).contains(".") && database.getDefaultSchemaName() != null && database.getOutputDefaultSchema()) {
                    referencesString = database.escapeObjectName(database.getDefaultSchemaName(), Schema.class) + "." + referencesString;
                }
                buffer.append((String)referencesString);
            } else {
                buffer.append(database.escapeObjectName(fkConstraint.getReferencedTableCatalogName(), fkConstraint.getReferencedTableSchemaName(), fkConstraint.getReferencedTableName(), Table.class)).append("(").append(database.escapeColumnNameList(fkConstraint.getReferencedColumnNames())).append(")");
            }
            if (fkConstraint.isDeleteCascade()) {
                buffer.append(" ON DELETE CASCADE");
            }
            if (fkConstraint.isInitiallyDeferred()) {
                buffer.append(" INITIALLY DEFERRED");
            }
            if (fkConstraint.isDeferrable()) {
                buffer.append(" DEFERRABLE");
            }
            buffer.append(!fkConstraint.shouldValidateForeignKey() ? " ENABLE NOVALIDATE " : "");
            buffer.append(",");
        }
        LinkedHashMap<String, UniqueConstraint> namedUniqueConstraints = new LinkedHashMap<String, UniqueConstraint>();
        LinkedList<Object> unnamedUniqueConstraints = new LinkedList<Object>();
        for (UniqueConstraint uniqueConstraint : statement.getUniqueConstraints()) {
            if (uniqueConstraint.getConstraintName() == null) {
                unnamedUniqueConstraints.add(uniqueConstraint);
                continue;
            }
            String constraintName = uniqueConstraint.getConstraintName();
            UniqueConstraint existingConstraint = (UniqueConstraint)namedUniqueConstraints.get(constraintName);
            if (existingConstraint != null) {
                if (uniqueConstraint.shouldValidateUnique()) {
                    existingConstraint.setValidateUnique(true);
                }
                existingConstraint.getColumns().addAll(uniqueConstraint.getColumns());
                continue;
            }
            namedUniqueConstraints.put(constraintName, uniqueConstraint);
        }
        unnamedUniqueConstraints.addAll(namedUniqueConstraints.values());
        for (UniqueConstraint uniqueConstraint : unnamedUniqueConstraints) {
            if (uniqueConstraint.getConstraintName() != null) {
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(uniqueConstraint.getConstraintName()));
            }
            buffer.append(" UNIQUE (");
            buffer.append(database.escapeColumnNameList(StringUtil.join((Collection)uniqueConstraint.getColumns(), (String)", ")));
            buffer.append(")");
            buffer.append(!uniqueConstraint.shouldValidateUnique() ? " ENABLE NOVALIDATE " : "");
            buffer.append(",");
        }
        String sql = buffer.toString().replaceFirst(",\\s*$", "") + ")";
        if (statement.getTablespace() != null && database.supportsTablespaces()) {
            sql = sql + " TABLESPACE " + statement.getTablespace();
        }
        additionalSql.add(0, new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)}));
        return additionalSql.toArray(new Sql[additionalSql.size()]);
    }
}

