/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import com.cyberway.mp.bc.liquibase.ext.oracle.utils.OracleDatabaseUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.DatabaseObject;

public class OracleInsertGenerator
extends InsertGenerator {
    private static final Pattern PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}$");

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(InsertStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public Sql[] generateSql(InsertStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        OracleDatabaseUtils.addAdditionReserveWords((OracleDatabase)database);
        StringBuilder sql = new StringBuilder();
        this.generateHeader(sql, statement, database);
        String sqlVal = this.generateSqlValues(sql, statement, database);
        return new Sql[]{new UnparsedSql(sqlVal, new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    public void generateHeader(StringBuilder sql, InsertStatement statement, Database database) {
        if (!(database instanceof OracleDatabase)) {
            super.generateHeader(sql, statement, database);
            return;
        }
        sql.append("INSERT INTO ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" (");
        for (String column : statement.getColumnValues().keySet()) {
            if (database.isReservedWord(column)) {
                column = column.toUpperCase();
            }
            sql.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column)).append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        int lastComma = sql.lastIndexOf(",");
        if (lastComma >= 0) {
            sql.deleteCharAt(lastComma);
        }
        sql.append(") VALUES ");
    }

    public String generateSqlValues(StringBuilder sql, InsertStatement statement, Database database) {
        if (!(database instanceof OracleDatabase)) {
            super.generateValues(sql, statement, database);
            return sql.toString();
        }
        sql.append("(");
        HashMap<String, String> longText = new HashMap<String, String>();
        for (String column2 : statement.getColumnValues().keySet()) {
            Object newValue = statement.getColumnValues().get(column2);
            if (newValue == null || "NULL".equalsIgnoreCase(newValue.toString())) {
                sql.append("NULL");
            } else if (newValue instanceof String && newValue.toString().length() > 4000) {
                if (database.isReservedWord(column2)) {
                    column2 = column2.toUpperCase();
                }
                sql.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column2));
                longText.put(column2, this.buildLongText(newValue.toString(), database));
            } else if (newValue instanceof String && this.matchTimestampValue(newValue.toString())) {
                sql.append(String.format("TO_TIMESTAMP('%s','yyyy-mm-dd\"T\"hh24:mi:ss')", newValue));
            } else if (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, database)) {
                sql.append(DataTypeFactory.getInstance().fromObject(newValue, database).objectToSql(newValue, database));
            } else if (newValue instanceof Date) {
                sql.append(database.getDateLiteral((Date)newValue));
            } else if (newValue instanceof Boolean) {
                if (Boolean.TRUE.equals(newValue)) {
                    sql.append(DataTypeFactory.getInstance().getTrueBooleanValue(database));
                } else {
                    sql.append(DataTypeFactory.getInstance().getFalseBooleanValue(database));
                }
            } else if (newValue instanceof DatabaseFunction) {
                sql.append(database.generateDatabaseFunctionValue((DatabaseFunction)newValue));
            } else {
                sql.append(newValue);
            }
            sql.append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        int lastComma = sql.lastIndexOf(",");
        if (lastComma >= 0) {
            sql.deleteCharAt(lastComma);
        }
        sql.append(")");
        if (!longText.isEmpty()) {
            StringBuilder sb = new StringBuilder("DECLARE").append(System.lineSeparator());
            longText.forEach((column, value) -> sb.append(String.format("%s clob := %s;", column, value)).append(System.lineSeparator()));
            sb.append("BEGIN").append(System.lineSeparator());
            sb.append((CharSequence)sql).append(";").append(System.lineSeparator());
            sb.append("commit;").append(System.lineSeparator());
            sb.append("end;").append(System.lineSeparator());
            return sb.toString();
        }
        return sql.toString();
    }

    private String buildLongText(String longText, Database database) {
        ArrayList<CallSite> part = new ArrayList<CallSite>();
        String temp = longText;
        while (temp.length() > 1000) {
            String item = temp.substring(0, 1000);
            part.add((CallSite)((Object)("to_clob(" + DataTypeFactory.getInstance().fromObject((Object)item, database).objectToSql((Object)item, database) + ")")));
            temp = temp.substring(1000);
        }
        return String.join((CharSequence)"||", part);
    }

    private boolean matchTimestampValue(String str) {
        Matcher m = PATTERN.matcher(str);
        return m.matches();
    }
}

