/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import java.util.Set;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.ModifyDataTypeGenerator;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.structure.DatabaseObject;

public class OracleModifyDataTypeGenerator
extends ModifyDataTypeGenerator {
    private static final Set<String> TARGET_TYPE = Set.of("clob", "text", "mediumtext", "longtext");

    public boolean supports(ModifyDataTypeStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Sql[] generateSql(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        String newDataType = statement.getNewDataType();
        if (!TARGET_TYPE.contains(newDataType.toLowerCase())) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        String tableName = database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        String columnName = database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        String columnNameBak = columnName + "_BAK";
        StringBuilder renameSql = new StringBuilder("ALTER TABLE " + tableName);
        renameSql.append(" rename column ").append(columnName).append(" to ").append(columnNameBak);
        StringBuilder newClobSql = new StringBuilder("ALTER TABLE " + tableName);
        newClobSql.append(" add ").append(columnName).append(" clob");
        StringBuilder updateSql = new StringBuilder("UPDATE " + tableName);
        updateSql.append(" set ").append(columnName).append(" = ").append(columnNameBak);
        StringBuilder dropSql = new StringBuilder("ALTER TABLE " + tableName);
        dropSql.append(" drop column ").append(columnNameBak);
        return new Sql[]{new UnparsedSql(renameSql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)}), new UnparsedSql(newClobSql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)}), new UnparsedSql(updateSql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)}), new UnparsedSql(dropSql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)})};
    }
}

