/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetColumnRemarksGenerator;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class OracleSetColumnRemarksGenerator
extends SetColumnRemarksGenerator {
    public boolean supports(SetColumnRemarksStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Sql[] generateSql(SetColumnRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        String remarksEscaped = database.escapeStringForDatabase(StringUtil.trimToEmpty((String)statement.getRemarks()));
        String columnName = statement.getColumnName();
        if (database.isReservedWord(columnName)) {
            columnName = columnName.toUpperCase();
        }
        return new Sql[]{new UnparsedSql("COMMENT ON COLUMN " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + "." + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), columnName) + " IS '" + remarksEscaped + "'", new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

