/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.liquibase.ext.oracle.sqlgenerator;

import java.util.Date;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.UpdateGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlUtil;

public class OracleUpdateGenerator
extends UpdateGenerator {
    public boolean supports(UpdateStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Sql[] generateSql(UpdateStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof OracleDatabase)) {
            return super.generateSql(statement, database, sqlGeneratorChain);
        }
        StringBuilder sql = new StringBuilder("UPDATE ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" SET");
        for (String column : statement.getNewColumnValues().keySet()) {
            sql.append(" ").append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column.toUpperCase())).append(" = ").append(this.convertToString(statement.getNewColumnValues().get(column), database)).append(",");
        }
        int lastComma = sql.lastIndexOf(",");
        if (lastComma >= 0) {
            sql.deleteCharAt(lastComma);
        }
        if (statement.getWhereClause() != null) {
            sql.append(" WHERE ").append(SqlUtil.replacePredicatePlaceholders((Database)database, (String)statement.getWhereClause(), (List)statement.getWhereColumnNames(), (List)statement.getWhereParameters()));
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString;
        if (newValue == null || "NULL".equalsIgnoreCase(newValue.toString())) {
            sqlString = "NULL";
        } else if (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, database)) {
            sqlString = DataTypeFactory.getInstance().fromObject(newValue, database).objectToSql(newValue, database);
        } else if (newValue instanceof Date) {
            Date date = (Date)newValue;
            if (date.getClass().equals(Date.class)) {
                date = new java.sql.Date(date.getTime());
            }
            sqlString = database.getDateLiteral(date);
        } else {
            sqlString = newValue instanceof Boolean ? (Boolean.TRUE.equals(newValue) ? DataTypeFactory.getInstance().getTrueBooleanValue(database) : DataTypeFactory.getInstance().getFalseBooleanValue(database)) : (newValue instanceof DatabaseFunction ? database.generateDatabaseFunctionValue((DatabaseFunction)newValue) : newValue.toString());
        }
        return sqlString;
    }
}

