/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.lock.annotation;

import com.cyberway.mp.bc.common.config.SpringContextUtil;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.bc.lock.annotation.DistributedLock;
import com.cyberway.mp.bc.lock.annotation.KeyGenerator;
import com.cyberway.mp.bc.lock.annotation.LockAcquireFailException;
import com.cyberway.mp.bc.lock.annotation.ObjectKeyGenerator;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.ObjectUtils;

@Aspect
public class LockAspect {
    private final LockService lockService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<Class<? extends KeyGenerator>, KeyGenerator> keyGeneratorMap = new ConcurrentHashMap<Class<? extends KeyGenerator>, KeyGenerator>();
    private static final Class<? extends KeyGenerator> DEFAULT_KEY_GENERATOR_CLASS = ObjectKeyGenerator.class;

    public LockAspect(LockService lockService) {
        this.lockService = lockService;
    }

    @Pointcut(value="@annotation(com.cyberway.mp.bc.lock.annotation.DistributedLock)")
    public void distributedLockPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="distributedLockPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        DistributedLock lockAnnotation = method.getAnnotation(DistributedLock.class);
        KeyGenerator keyGenerator = this.buildKeyGenerator(lockAnnotation.keyGenerator());
        String lockKey = String.format("%s%s", lockAnnotation.prefix(), keyGenerator.generate(joinPoint.getThis(), method, joinPoint.getArgs()));
        boolean isLocked = false;
        try {
            this.logger.debug("\u5206\u5e03\u5f0f\u9501\u62e6\u622a\u65b9\u6cd5\uff1a{}", (Object)method.getName());
            if (lockAnnotation.waitTime() >= 0L) {
                isLocked = this.lockService.tryLock(lockKey, lockAnnotation.timeUnit(), lockAnnotation.waitTime(), lockAnnotation.leaseTime());
                if (!isLocked) {
                    this.logger.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u9501Key: {}", (Object)lockKey);
                    throw new LockAcquireFailException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u9501Key: " + lockKey);
                }
            } else {
                this.lockService.lock(lockKey, lockAnnotation.timeUnit(), lockAnnotation.leaseTime());
                isLocked = true;
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            if (isLocked) {
                this.lockService.unlock(lockKey);
            }
        }
    }

    private KeyGenerator buildKeyGenerator(Class<? extends KeyGenerator> keyGeneratorClazz) {
        if (ObjectUtils.isEmpty(keyGeneratorClazz)) {
            keyGeneratorClazz = DEFAULT_KEY_GENERATOR_CLASS;
        }
        return keyGeneratorMap.computeIfAbsent(keyGeneratorClazz, this::instantiateKeyGenerator);
    }

    private KeyGenerator instantiateKeyGenerator(Class<? extends KeyGenerator> keyGeneratorClazz) {
        try {
            return (KeyGenerator)SpringContextUtil.getBean(keyGeneratorClazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.info(String.format("\u672a\u627e\u5230 KeyGenerator Bean [%s]\uff0c\u5c06\u4f7f\u7528\u53cd\u5c04\u521b\u5efa\u5b9e\u4f8b", keyGeneratorClazz.getName()));
        }
        catch (Exception e) {
            throw new LockAcquireFailException(String.format("\u4ece Spring \u5bb9\u5668\u83b7\u53d6 KeyGenerator Bean [%s] \u65f6\u53d1\u751f\u9519\u8bef: %s", keyGeneratorClazz.getName(), ExceptionUtils.getMessage((Throwable)e)));
        }
        try {
            return keyGeneratorClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new LockAcquireFailException("KeyGenerator [" + keyGeneratorClazz.getName() + "] \u5b9e\u4f8b\u5316\u5931\u8d25");
        }
    }
}

