/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.lock.annotation;

import com.cyberway.mp.bc.lock.annotation.KeyGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.cache.interceptor.SimpleKey;

public class ObjectKeyGenerator
implements KeyGenerator {
    public static final String BEAN_NAME = "lockObjectKeyGenerator";
    private static final int MAX_RECURSION_DEPTH = 5;

    @Override
    public String generate(Object target, Method method, Object ... params) {
        return (target == null ? "nullTarget" : target.getClass().getSimpleName()) + ":" + method.getName() + ":" + ObjectKeyGenerator.generateKey(params);
    }

    public static Object generateKey(Object ... params) {
        if (params.length == 0) {
            return SimpleKey.EMPTY;
        }
        ArrayList<Object> flattenedList = new ArrayList<Object>();
        ObjectKeyGenerator.flattenParams(params, flattenedList, 0);
        return Arrays.deepHashCode(flattenedList.toArray());
    }

    private static void flattenParams(Object[] params, List<Object> flattenedList, int depth) {
        if (depth >= 5) {
            Collections.addAll(flattenedList, params);
            return;
        }
        for (Object param : params) {
            if (param != null && Collection.class.isAssignableFrom(param.getClass())) {
                Collection collection = (Collection)param;
                ObjectKeyGenerator.flattenParams(collection.toArray(), flattenedList, depth + 1);
                continue;
            }
            flattenedList.add(param);
        }
    }
}

