/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.lock.redisson;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.bc.lock.annotation.LockAspect;
import com.cyberway.mp.bc.lock.constant.LockErrorCode;
import com.cyberway.mp.bc.lock.redisson.RedissonConfigCustomizer;
import com.cyberway.mp.bc.lock.redisson.RedissonProperties;
import com.cyberway.mp.bc.lock.redisson.RedissonService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;

@Configuration
@ConditionalOnProperty(value={"commons.lock.type"}, havingValue="REDISSON", matchIfMissing=true)
@EnableConfigurationProperties(value={RedissonProperties.class, RedisProperties.class})
public class RedissonConfig
implements ResourceLoaderAware {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResourceLoader resourceLoader;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired(required=false)
    private List<RedissonConfigCustomizer> redissonConfigCustomizers;
    @Value(value="${spring.redis.custom-ssl.enabled:false}")
    private boolean enableCustomSsl;
    @Value(value="${spring.redis.custom-ssl.trust-store-resource-path:}")
    private String customSslTrustStoreResourcePath;
    @Value(value="${spring.redis.custom-ssl.trust-store-password:}")
    private String customSslTrustStorePassword;
    @Value(value="${spring.redis.custom-ssl.disable-peer-verification:false}")
    private boolean customSslDisablePeerVerification;

    @Bean
    @ConditionalOnMissingBean
    public Config config() throws IOException {
        Config config = new Config();
        try {
            BaseConfig baseConfig;
            int timeout = null == this.redisProperties.getTimeout() ? 10000 : (int)this.redisProperties.getTimeout().toMillis();
            config.setThreads(this.redissonProperties.getThreads().intValue());
            config.setNettyThreads(this.redissonProperties.getNettyThreads().intValue());
            config.setCodec((Codec)Class.forName(this.redissonProperties.getCodec()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            if (null != this.redisProperties.getCluster()) {
                RedisProperties.Cluster cluster = this.redisProperties.getCluster();
                nodes = this.convert(cluster.getNodes());
                baseConfig = ((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setUsername(this.redisProperties.getUsername())).setPassword(this.redisProperties.getPassword());
            } else if (null != this.redisProperties.getSentinel()) {
                RedisProperties.Sentinel sentinel = this.redisProperties.getSentinel();
                nodes = this.convert(sentinel.getNodes());
                baseConfig = ((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(sentinel.getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout)).setUsername(this.redisProperties.getUsername())).setPassword(this.redisProperties.getPassword());
            } else {
                String prefix = REDIS_PROTOCOL_PREFIX;
                if (this.redisProperties.getSsl().isEnabled()) {
                    prefix = REDISS_PROTOCOL_PREFIX;
                }
                baseConfig = ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase()).setUsername(this.redisProperties.getUsername())).setPassword(this.redisProperties.getPassword());
            }
            this.initCustomSslConfig(baseConfig);
            if (this.redissonConfigCustomizers != null) {
                for (RedissonConfigCustomizer customizer : this.redissonConfigCustomizers) {
                    customizer.customize(config);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Configuration of Redisson is not correctly: {}", (Object)config.toYAML());
        }
        return config;
    }

    private void initCustomSslConfig(BaseConfig<?> baseConfig) {
        if (!this.enableCustomSsl) {
            return;
        }
        baseConfig.setSslProvider(SslProvider.JDK);
        baseConfig.setSslEnableEndpointIdentification(!this.customSslDisablePeerVerification);
        if (StringUtils.isNotBlank((CharSequence)this.customSslTrustStoreResourcePath)) {
            try {
                Resource resource = this.resourceLoader.getResource(this.customSslTrustStoreResourcePath);
                baseConfig.setSslTruststore(resource.getURL());
                if (StringUtils.isNotBlank((CharSequence)this.customSslTrustStorePassword)) {
                    baseConfig.setSslTruststorePassword(this.customSslTrustStorePassword);
                }
            }
            catch (Exception e) {
                throw new BaseException((ErrorCode)LockErrorCode.READ_TRUST_STORE_FILE_FAILED, (Throwable)e, new Object[0]);
            }
        }
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public RedissonClient redissonClient(Config config) throws IOException {
        this.logger.debug("create RedissonClient, config is : {}", (Object)config.toYAML());
        return Redisson.create((Config)config);
    }

    @Bean
    public RedissonService lockService(RedissonClient redissonClient) {
        return new RedissonService(redissonClient);
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<Object> nodes = new ArrayList<Object>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Bean
    public LockAspect lockAspect(LockService lockService) {
        return new LockAspect(lockService);
    }
}

