/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.lock.redisson;

import com.cyberway.mp.bc.lock.LockKey;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.bc.lock.redisson.RedissonLockKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonService
implements LockService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RedissonClient redissonClient;

    public RedissonService(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public LockKey lock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock();
        return new RedissonLockKey((Lock)lock);
    }

    @Override
    public LockKey lock(String lockKey, long leaseTimeSeconds) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(leaseTimeSeconds, TimeUnit.SECONDS);
        return new RedissonLockKey((Lock)lock);
    }

    @Override
    public LockKey lock(String lockKey, TimeUnit unit, long leaseTime) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(leaseTime, unit);
        return new RedissonLockKey((Lock)lock);
    }

    @Override
    public boolean tryLock(String lockKey, TimeUnit unit, long waitTime, long leaseTime) {
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            return lock.tryLock(waitTime, leaseTime, unit);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void unlock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.unlock();
    }

    @Override
    public void unlock(LockKey lock) {
        if (!(lock instanceof RedissonLockKey)) {
            throw new UnsupportedOperationException("lock type error");
        }
        RedissonLockKey lockKey = (RedissonLockKey)lock;
        lockKey.getLock().unlock();
    }
}

