/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.retry;

import com.github.rholder.retry.AttemptTimeLimiter;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CustomFixedAttemptTimeLimit<V>
implements AttemptTimeLimiter<V> {
    private final TimeLimiter timeLimiter;
    private final long duration;
    private final TimeUnit timeUnit;

    public CustomFixedAttemptTimeLimit(long duration, @Nonnull TimeUnit timeUnit, @Nonnull ExecutorService executorService) {
        this((TimeLimiter)SimpleTimeLimiter.create((ExecutorService)executorService), duration, timeUnit);
    }

    private CustomFixedAttemptTimeLimit(@Nonnull TimeLimiter timeLimiter, long duration, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)timeLimiter);
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        this.timeLimiter = timeLimiter;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public V call(Callable<V> callable) throws Exception {
        return (V)this.timeLimiter.callWithTimeout(callable, this.duration, this.timeUnit);
    }
}

