/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.retry.aop;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.retry.CustomFixedAttemptTimeLimit;
import com.cyberway.mp.bc.retry.RetryContext;
import com.cyberway.mp.bc.retry.annotation.EnableRetry;
import com.cyberway.mp.bc.retry.callable.AbstractRetryCallable;
import com.cyberway.mp.bc.retry.dto.RequestRetryDto;
import com.cyberway.mp.bc.retry.dto.ResponseRetryDto;
import com.cyberway.mp.bc.retry.dto.RetryParam;
import com.cyberway.mp.bc.retry.listener.DefaultRetryListener;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=1)
@Component
public class RetryAspect
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executorService = new ThreadPoolExecutor(5, 20, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    private ApplicationContext applicationContext;

    @Pointcut(value="@annotation(com.cyberway.mp.bc.retry.annotation.EnableRetry)")
    public void aop() {
    }

    @Around(value="aop()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        return this.process(point);
    }

    private Object process(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = method.getName();
        this.logger.info("\u91cd\u8bd5\u7ec4\u4ef6aop\u5207\u9762\u5904\u7406begin, className={}, methodName={}", (Object)className, (Object)methodName);
        if (Boolean.TRUE.equals(ServiceContext.getContext().getRetryFlag())) {
            this.logger.info("\u4e0a\u6e38\u670d\u52a1\u5df2\u5b9e\u73b0\u91cd\u8bd5\uff0c\u5f53\u524d\u4e1a\u52a1\u5ffd\u7565\u91cd\u8bd5, className={}, methodName={}", (Object)className, (Object)methodName);
            return joinPoint.proceed();
        }
        ServiceContext.getContext().setAttachment("req.retryFlag", "true");
        EnableRetry enableRetry = method.getDeclaredAnnotation(EnableRetry.class);
        Retryer retryer = null;
        Callable<Object> callable = null;
        Object result = null;
        try {
            Map<String, Object> requestParams = this.getRequestParams(joinPoint, methodSignature);
            RetryParam retryParam = this.getRetryParam(joinPoint, methodSignature);
            this.initializationRetryContext(className, methodName, requestParams);
            callable = this.getCallable(enableRetry.callable(), joinPoint, requestParams);
            if (enableRetry.maxDelayMsec() <= 0L && enableRetry.maxAttempt() <= 1 && (retryParam == null || retryParam.getWaitMsec() <= 0L && retryParam.getMaxAttempt() <= 1)) {
                Object object = joinPoint.proceed();
                return object;
            }
            RetryerBuilder retryerBuilder = this.getRetryerBuilder(enableRetry, retryParam);
            Predicate resultPredicate = null;
            if (enableRetry.retryResult() != null && !Predicate.class.equals(enableRetry.retryResult()) && Predicate.class.isAssignableFrom(enableRetry.retryResult())) {
                resultPredicate = enableRetry.retryResult().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                retryerBuilder.retryIfResult(resultPredicate);
            }
            retryer = retryerBuilder.build();
            if (enableRetry.async()) {
                result = joinPoint.proceed();
                this.logger.info("\u91cd\u8bd5\u7ec4\u4ef6\u5f02\u6b65\u6267\u884c\u91cd\u8bd5, \u624b\u52a8\u6267\u884c\u4e1a\u52a1\u65b9\u6cd5\uff0c\u6ca1\u6709\u53d1\u751f\u91cd\u8bd5\u5f02\u5e38, className={}, methodName={}, result={}", new Object[]{className, methodName, JSON.toJSONString((Object)result)});
                if (resultPredicate != null && resultPredicate.apply(result)) {
                    this.processAsyncRetry(enableRetry, retryer, callable, className, methodName);
                }
            } else {
                result = retryer.call(callable);
            }
        }
        catch (Exception e) {
            if (enableRetry.async()) {
                boolean hasRetryException = false;
                for (Class<? extends Throwable> throwableClass : enableRetry.retryThrowable()) {
                    if (throwableClass == null || !Throwable.class.isAssignableFrom(throwableClass) || !throwableClass.isAssignableFrom(e.getClass())) continue;
                    hasRetryException = true;
                    break;
                }
                if (hasRetryException) {
                    this.logger.info("\u91cd\u8bd5\u7ec4\u4ef6\u5f02\u6b65\u6267\u884c\u91cd\u8bd5, \u624b\u52a8\u6267\u884c\u4e1a\u52a1\u65b9\u6cd5, \u53d1\u751f\u5f02\u5e38, className={}, methodName={}, message={}", new Object[]{className, methodName, e.getMessage()});
                    this.processAsyncRetry(enableRetry, retryer, callable, className, methodName);
                }
            } else {
                this.logger.error("\u91cd\u8bd5\u7ec4\u4ef6aop\u5207\u9762\u5904\u7406error, methodName={}, message={}, message={}", new Object[]{className, methodName, e.getMessage(), e});
                if (e.getMessage() != null && e.getMessage().startsWith("Retrying failed to complete successfully after")) {
                    ResponseRetryDto responseRetryDto = RetryContext.getContext().getResponseRetryDto();
                    Object object = responseRetryDto.getResult();
                    return object;
                }
            }
            throw e;
        }
        finally {
            RetryContext.getContext().clearContext();
            ServiceContext.getContext().setAttachment("req.retryFlag", "false");
        }
        return result;
    }

    private Callable<Object> getCallable(Class<? extends AbstractRetryCallable> callableClass, ProceedingJoinPoint joinPoint, Map<String, Object> requestParams) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<? extends AbstractRetryCallable> declaredConstructor = callableClass.getDeclaredConstructor(ProceedingJoinPoint.class, ApplicationContext.class);
        Callable callable = declaredConstructor.newInstance(joinPoint, this.applicationContext);
        return callable;
    }

    private RetryerBuilder getRetryerBuilder(EnableRetry enableRetry, RetryParam retryParam) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        RetryerBuilder retryerBuilder = RetryerBuilder.newBuilder();
        if (enableRetry.retryThrowable().length > 0) {
            for (Class<? extends Throwable> clazz : enableRetry.retryThrowable()) {
                if (clazz == null || !Throwable.class.isAssignableFrom(clazz)) continue;
                retryerBuilder.retryIfExceptionOfType(clazz);
            }
        }
        if (retryParam != null) {
            if (retryParam.getWaitMsec() > 0L) {
                retryerBuilder.withWaitStrategy(WaitStrategies.fixedWait((long)retryParam.getWaitMsec(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            if (retryParam.getMaxAttempt() > 0) {
                int maxAttempt = enableRetry.async() ? retryParam.getMaxAttempt() : retryParam.getMaxAttempt() + 1;
                retryerBuilder.withStopStrategy(StopStrategies.stopAfterAttempt((int)maxAttempt));
            }
        } else {
            if (enableRetry.waitMsec() > 0L) {
                retryerBuilder.withWaitStrategy(WaitStrategies.fixedWait((long)enableRetry.waitMsec(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            if (enableRetry.maxAttempt() > 0) {
                int maxAttempt = enableRetry.async() ? enableRetry.maxAttempt() : enableRetry.maxAttempt() + 1;
                retryerBuilder.withStopStrategy(StopStrategies.stopAfterAttempt((int)maxAttempt));
            } else if (enableRetry.maxDelayMsec() > 0L) {
                retryerBuilder.withStopStrategy(StopStrategies.stopAfterDelay((long)enableRetry.maxDelayMsec(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
        }
        if (enableRetry.timeLimiterMsec() > 0L) {
            retryerBuilder.withAttemptTimeLimiter(new CustomFixedAttemptTimeLimit(enableRetry.timeLimiterMsec(), TimeUnit.MILLISECONDS, this.executorService));
        }
        retryerBuilder.withRetryListener((RetryListener)new DefaultRetryListener());
        if (enableRetry.listeners().length > 0) {
            for (Class<? extends Throwable> clazz : enableRetry.listeners()) {
                if (clazz == null || !RetryListener.class.isAssignableFrom(clazz)) continue;
                Throwable listenerObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                retryerBuilder.withRetryListener((RetryListener)listenerObject);
            }
        }
        return retryerBuilder;
    }

    private void initializationRetryContext(String className, String methodName, Map<String, Object> requestParams) {
        RetryContext.getContext().setRequestRetryDto(new RequestRetryDto(className, methodName, requestParams));
        RetryContext.getContext().setResponseRetryDto(new ResponseRetryDto());
    }

    private Map<String, Object> getRequestParams(ProceedingJoinPoint joinPoint, MethodSignature methodSignature) {
        String[] parameterNames = methodSignature.getParameterNames();
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (int i = 0; i < parameterNames.length; ++i) {
            String key = parameterNames[i];
            Object value = joinPoint.getArgs()[i];
            value = value instanceof HttpServletRequest ? "request" : (value instanceof HttpServletResponse ? "response" : joinPoint.getArgs()[i]);
            requestParams.put(key, value);
        }
        return requestParams;
    }

    private RetryParam getRetryParam(ProceedingJoinPoint joinPoint, MethodSignature methodSignature) {
        String[] parameterNames = methodSignature.getParameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            Object value = joinPoint.getArgs()[i];
            if (!(value instanceof RetryParam)) continue;
            return (RetryParam)value;
        }
        return null;
    }

    private void processAsyncRetry(EnableRetry enableRetry, Retryer retryer, Callable callable, String className, String methodName) {
        try {
            if (enableRetry.waitMsec() > 0L) {
                Thread.sleep(enableRetry.waitMsec());
            }
            this.executorService.execute(() -> {
                try {
                    retryer.call(callable);
                }
                catch (Exception e) {
                    this.logger.error("\u91cd\u8bd5\u7ec4\u4ef6\u5f02\u6b65\u6267\u884c\u91cd\u8bd5error, methodName={}, message={}, message={}", new Object[]{className, methodName, e.getMessage(), e});
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("\u91cd\u8bd5\u7ec4\u4ef6\u5f02\u6b65\u6267\u884c\u91cd\u8bd5error, methodName={}, message={}, message={}", new Object[]{className, methodName, e.getMessage(), e});
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

