/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.retry.callable;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.retry.RetryContext;
import java.util.Map;
import java.util.concurrent.Callable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRetryCallable
implements Callable<Object> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ProceedingJoinPoint point;
    protected ApplicationContext applicationContext;
    protected Map<String, Object> requestParams;

    protected AbstractRetryCallable(ProceedingJoinPoint point, ApplicationContext applicationContext) {
        this.point = point;
        this.applicationContext = applicationContext;
        this.requestParams = RetryContext.getContext().getRequestRetryDto().getRequestParams();
    }

    protected abstract boolean before();

    @Override
    public Object call() throws Exception {
        Object proceed = null;
        try {
            boolean validate = this.before();
            if (!validate) {
                this.logger.info("\u5f53\u524d\u91cd\u8bd5\u6821\u9a8c\u4e0d\u901a\u8fc7, \u5ffd\u7565\u540e\u7eed\u91cd\u8bd5, className={}, methodName={}", (Object)RetryContext.getContext().getRequestRetryDto().getClassName(), (Object)RetryContext.getContext().getRequestRetryDto().getMethodName());
            } else {
                proceed = this.point.proceed();
            }
        }
        catch (Throwable throwable) {
            throw new BaseException(throwable);
        }
        finally {
            this.after();
        }
        return proceed;
    }

    protected abstract void after();

    public ProceedingJoinPoint getPoint() {
        return this.point;
    }

    public void setPoint(ProceedingJoinPoint point) {
        this.point = point;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
    }
}

