/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.retry.listener;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.retry.RetryContext;
import com.cyberway.mp.bc.retry.dto.RequestRetryDto;
import com.cyberway.mp.bc.retry.dto.ResponseRetryDto;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryListener
implements RetryListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public <V> void onRetry(Attempt<V> attempt) {
        RequestRetryDto requestRetryDto = RetryContext.getContext().getRequestRetryDto();
        String className = requestRetryDto.getClassName();
        String methodName = requestRetryDto.getMethodName();
        long attemptNumber = attempt.getAttemptNumber();
        ResponseRetryDto responseRetryDto = RetryContext.getContext().getResponseRetryDto();
        responseRetryDto.setAttemptNumber(attemptNumber);
        if (attempt.hasException()) {
            if ("java.util.concurrent.TimeoutException".equals(attempt.getExceptionCause().getMessage())) {
                this.logger.info("\u91cd\u8bd5\u7b2c{}\u6b21error, \u672c\u6b21\u91cd\u8bd5\u5df2\u8d85\u65f6, className={}, methodName={}, hasException={}, exceptionMessage={}", new Object[]{attemptNumber, className, methodName, attempt.hasException(), attempt.getExceptionCause().getMessage()});
            } else {
                this.logger.info("\u91cd\u8bd5\u7b2c{}\u6b21error, className={}, methodName={}, hasException={}, exceptionMessage={}", new Object[]{attemptNumber, className, methodName, attempt.hasException(), attempt.getExceptionCause().getMessage()});
            }
        } else {
            this.logger.info("\u91cd\u8bd5\u7b2c{}\u6b21success, className={}, methodName={}, hasResult={}, result={}", new Object[]{attemptNumber, className, methodName, attempt.hasResult(), JSON.toJSONString((Object)attempt.getResult())});
            if (attempt.hasResult()) {
                Object result = attempt.getResult();
                responseRetryDto.setResult(result);
            }
        }
    }
}

