/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.seata.config;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.ScannerChecker;
import io.seata.spring.annotation.datasource.SeataAutoDataSourceProxyCreator;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ResourceLoader;

public class CustomSeataAutoConfiguration {
    @Bean(value={"failureHandler"})
    @ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true")
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider", "failureHandler"})
    @ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true")
    public GlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler, ConfigurableListableBeanFactory beanFactory, @Autowired(required=false) List<ScannerChecker> scannerCheckers) {
        GlobalTransactionScanner.setBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        GlobalTransactionScanner.addScannerCheckers((Collection)EnhancedServiceLoader.loadAll(ScannerChecker.class));
        GlobalTransactionScanner.addScannerCheckers(scannerCheckers);
        GlobalTransactionScanner.addScannablePackages((String[])seataProperties.getScanPackages());
        GlobalTransactionScanner.addScannerExcludeBeanNames((String[])seataProperties.getExcludesForScanning());
        GlobalTransactionScanner.setAccessKey((String)seataProperties.getAccessKey());
        GlobalTransactionScanner.setSecretKey((String)seataProperties.getSecretKey());
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Bean(value={"seataAutoDataSourceProxyCreator"})
    @ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true")
    public SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator(SeataProperties seataProperties) {
        return new SeataAutoDataSourceProxyCreator(seataProperties.isUseJdkProxy(), seataProperties.getExcludesForAutoProxying(), seataProperties.getDataSourceProxyMode());
    }

    @Bean(name={"seataLiquibaseManger"})
    @ConditionalOnExpression(value="(${seata.enable:true}||${seata.enabled:true}) && ${spring.liquibase.enabled:true}")
    public SpringLiquibase seataLiquibaseManger(DataSource dataSource, ResourceLoader resourceLoader) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setResourceLoader(resourceLoader);
        liquibase.setChangeLog("classpath:seata-liquibase-master.xml");
        liquibase.setDatabaseChangeLogTable("seata_database_change_log");
        liquibase.setDatabaseChangeLogLockTable("seata_database_change_log_lock");
        return liquibase;
    }
}

